/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.util.Vector;
import org.j_paine.formatter.EndOfVectorOnWriteException;
import org.j_paine.formatter.FormatElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.FormatOutputList;
import org.j_paine.formatter.InputStreamAndBuffer;

final class VectorAndPointer
implements FormatInputList,
FormatOutputList {
    private Vector v = null;
    private int vecptr = 0;

    public VectorAndPointer(Vector vector) {
        this.v = vector;
    }

    public VectorAndPointer() {
        this.v = new Vector();
    }

    public boolean hasCurrentElement() {
        return this.vecptr < this.v.size();
    }

    @Override
    public void checkCurrentElementForWrite(FormatElement formatElement) throws EndOfVectorOnWriteException {
        if (!this.hasCurrentElement()) {
            throw new EndOfVectorOnWriteException(this.vecptr, formatElement.toString());
        }
    }

    @Override
    public void checkCurrentElementForRead(FormatElement formatElement, InputStreamAndBuffer inputStreamAndBuffer) {
    }

    public Object getCurrentElement() {
        return this.v.elementAt(this.vecptr);
    }

    @Override
    public Object getCurrentElementAndAdvance() {
        ++this.vecptr;
        return this.v.elementAt(this.vecptr - 1);
    }

    @Override
    public void putElementAndAdvance(Object object, FormatElement formatElement, InputStreamAndBuffer inputStreamAndBuffer) {
        this.v.addElement(object);
        ++this.vecptr;
    }

    public void advance() {
        ++this.vecptr;
    }

    @Override
    public int getPtr() {
        return this.vecptr;
    }
}

