/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import org.netlib.util.intW;

public class QRP {
    int[] jpvt;
    final double[] tau;
    final int m;
    final int n;
    final int k;
    int rank;
    double[] work;
    final DenseMatrix Afact;
    final DenseMatrix Q;
    final DenseMatrix R;

    public QRP(int m, int n) {
        this.m = m;
        this.n = n;
        this.k = Math.min(m, n);
        this.rank = 0;
        this.jpvt = new int[n];
        this.tau = new double[this.k];
        this.Q = new DenseMatrix(m, m);
        this.R = new DenseMatrix(m, n);
        this.Afact = new DenseMatrix(m, Math.max(m, n));
        intW info = new intW(0);
        double[] dummy = new double[1];
        double[] ret = new double[1];
        LAPACK lapack = LAPACK.getInstance();
        lapack.dgeqrf(m, n, dummy, Matrices.ld(m), dummy, ret, -1, info);
        int lwork1 = info.val != 0 ? n : (int)ret[0];
        lapack.dorgqr(m, m, this.k, dummy, Matrices.ld(m), dummy, ret, -1, info);
        int lwork2 = info.val != 0 ? n : (int)ret[0];
        this.work = new double[Math.max(lwork1, lwork2)];
    }

    public static QRP factorize(Matrix A) {
        return new QRP(A.numRows(), A.numColumns()).factor(A);
    }

    public QRP factor(Matrix A) {
        if (this.Q.numRows() != A.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.R.numColumns() != A.numColumns()) {
            throw new IllegalArgumentException("R.numColumns() != A.numColumns()");
        }
        this.Afact.zero();
        for (MatrixEntry e : A) {
            this.Afact.set(e.row(), e.column(), e.get());
        }
        intW info = new intW(0);
        LAPACK lapack = LAPACK.getInstance();
        double[] factorWorkOptimalSize = new double[]{0.0};
        lapack.dgeqp3(this.m, this.n, this.Afact.getData(), Matrices.ld(this.m), this.jpvt, this.tau, factorWorkOptimalSize, -1, info);
        double[] factorWork = new double[(int)factorWorkOptimalSize[0]];
        lapack.dgeqp3(this.m, this.n, this.Afact.getData(), Matrices.ld(this.m), this.jpvt, this.tau, factorWork, factorWork.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException("DGEQP3 was " + info.val);
        }
        this.R.zero();
        for (MatrixEntry e : this.Afact) {
            if (e.row() > e.column() || e.column() >= this.R.numColumns()) continue;
            this.R.set(e.row(), e.column(), e.get());
        }
        double EPS = 1.0E-12;
        this.rank = 0;
        while (this.rank < this.k) {
            if (Math.abs(this.R.get(this.rank, this.rank)) < 1.0E-12) break;
            ++this.rank;
        }
        lapack.dorgqr(this.m, this.m, this.k, this.Afact.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        for (MatrixEntry e : this.Afact) {
            if (e.column() >= this.Q.numColumns()) continue;
            this.Q.set(e.row(), e.column(), e.get());
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.jpvt.length) {
            int n = i++;
            this.jpvt[n] = this.jpvt[n] - 1;
        }
        return this;
    }

    public DenseMatrix getR() {
        return this.R;
    }

    public DenseMatrix getQ() {
        return this.Q;
    }

    public int[] getPVector() {
        return this.jpvt;
    }

    public Matrix getP() {
        DenseMatrix P = new DenseMatrix(this.jpvt.length, this.jpvt.length);
        int i = 0;
        while (i < this.jpvt.length) {
            P.set(this.jpvt[i], i, 1.0);
            ++i;
        }
        return P;
    }

    public int getRank() {
        return this.rank;
    }
}

