/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Arrays;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;

public class SSOR
implements Preconditioner {
    private double omegaF;
    private double omegaR;
    private final CompRowMatrix F;
    private final int[] diagind;
    private final double[] xx;
    private final boolean reverse;

    public SSOR(CompRowMatrix F, boolean reverse, double omegaF, double omegaR) {
        if (!F.isSquare()) {
            throw new IllegalArgumentException("SSOR only applies to square matrices");
        }
        this.F = F;
        this.reverse = reverse;
        this.setOmega(omegaF, omegaR);
        int n = F.numRows();
        this.diagind = new int[n];
        this.xx = new double[n];
    }

    public SSOR(CompRowMatrix F) {
        this(F, true, 1.0, 1.0);
    }

    public void setOmega(double omegaF, double omegaR) {
        if (omegaF < 0.0 || omegaF > 2.0) {
            throw new IllegalArgumentException("omegaF must be between 0 and 2");
        }
        if (omegaR < 0.0 || omegaR > 2.0) {
            throw new IllegalArgumentException("omegaR must be between 0 and 2");
        }
        this.omegaF = omegaF;
        this.omegaR = omegaR;
    }

    @Override
    public void setMatrix(Matrix A) {
        this.F.set(A);
        int n = this.F.numRows();
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndices();
        int k = 0;
        while (k < n) {
            this.diagind[k] = Arrays.binarySearch(colind, rowptr[k], rowptr[k + 1], k);
            if (this.diagind[k] < 0) {
                throw new RuntimeException("Missing diagonal on row " + (k + 1));
            }
            ++k;
        }
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        int j;
        double sigma;
        if (!(b instanceof DenseVector) || !(x instanceof DenseVector)) {
            throw new IllegalArgumentException("Vectors must be DenseVectors");
        }
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndices();
        double[] data = this.F.getData();
        double[] bd = ((DenseVector)b).getData();
        double[] xd = ((DenseVector)x).getData();
        int n = this.F.numRows();
        System.arraycopy(xd, 0, this.xx, 0, n);
        int i = 0;
        while (i < n) {
            sigma = 0.0;
            j = rowptr[i];
            while (j < this.diagind[i]) {
                sigma += data[j] * this.xx[colind[j]];
                ++j;
            }
            j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                sigma += data[j] * xd[colind[j]];
                ++j;
            }
            sigma = (bd[i] - sigma) / data[this.diagind[i]];
            this.xx[i] = xd[i] + this.omegaF * (sigma - xd[i]);
            ++i;
        }
        if (!this.reverse) {
            System.arraycopy(this.xx, 0, xd, 0, n);
            return x;
        }
        i = n - 1;
        while (i >= 0) {
            sigma = 0.0;
            j = rowptr[i];
            while (j < this.diagind[i]) {
                sigma += data[j] * this.xx[colind[j]];
                ++j;
            }
            j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                sigma += data[j] * xd[colind[j]];
                ++j;
            }
            sigma = (bd[i] - sigma) / data[this.diagind[i]];
            xd[i] = this.xx[i] + this.omegaR * (sigma - this.xx[i]);
            --i;
        }
        return x;
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        return this.apply(b, x);
    }
}

