/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

public final class Daxpy {
    public static void daxpy(int n, double da, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy) {
        if (n <= 0 || da == 0.0) {
            return;
        }
        if (incx != 1 || incy != 1) {
            int ix = 1;
            int iy = 1;
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incy < 0) {
                iy = (-n + 1) * incy + 1;
            }
            int k = n;
            while (k > 0) {
                dy[iy - 1 + _dy_offset] = dy[iy - 1 + _dy_offset] + da * dx[ix - 1 + _dx_offset];
                ix += incx;
                iy += incy;
                --k;
            }
            return;
        }
        int j = 0;
        while (j < n) {
            int n2 = j + _dy_offset;
            dy[n2] = dy[n2] + da * dx[j + _dx_offset];
            ++j;
        }
    }
}

