/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.DtrmmNetlib;
import org.netlib.blas.Lsame;
import org.netlib.blas.Trmm;
import org.netlib.err.Xerbla;

public final class Dtrmm {
    public static void dtrmm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb) {
        boolean lside = Lsame.lsame(side, "L");
        boolean nounit = Lsame.lsame(diag, "N");
        boolean upper = Lsame.lsame(uplo, "U");
        boolean notrans = Lsame.lsame(transa, "N");
        int info = 0;
        if (!lside && !Lsame.lsame(side, "R")) {
            info = 1;
        } else if (!upper && !Lsame.lsame(uplo, "L")) {
            info = 2;
        } else if (!(notrans || Lsame.lsame(transa, "T") || Lsame.lsame(transa, "C"))) {
            info = 3;
        } else if (!nounit && !Lsame.lsame(diag, "U")) {
            info = 4;
        } else if (m < 0) {
            info = 5;
        } else if (n < 0) {
            info = 6;
        } else if (lda < Math.max(1, lside ? m : n)) {
            info = 9;
        } else if (ldb < Math.max(1, m)) {
            info = 11;
        }
        if (info != 0) {
            Xerbla.xerbla("DTRMM ", info);
            return;
        }
        if (n == 0) {
            return;
        }
        if (lside && Math.min(m, n) > 190 || !lside && Math.min(m, n) > 280) {
            Trmm.trmm(lside, !upper, !notrans, !nounit, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb);
        } else {
            DtrmmNetlib.dtrmm(lside, upper, notrans, nounit, m, n, alpha, a, _a_offset, lda, b, _b_offset, ldb);
        }
    }
}

