/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

final class DtrmmNetlib {
    DtrmmNetlib() {
    }

    static void dtrmm(boolean lside, boolean upper, boolean notrans, boolean nounit, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb) {
        if (alpha == 0.0) {
            int j = 1;
            int p = n;
            while (p > 0) {
                int i = 1;
                int q = m;
                while (q > 0) {
                    b[i - 1 + (j - 1) * ldb + _b_offset] = 0.0;
                    ++i;
                    --q;
                }
                ++j;
                --p;
            }
            return;
        }
        if (lside) {
            if (notrans) {
                if (upper) {
                    int j = 1;
                    int p = n;
                    while (p > 0) {
                        int k = 1;
                        int q = m;
                        while (q > 0) {
                            if (b[k - 1 + (j - 1) * ldb + _b_offset] != 0.0) {
                                double temp = alpha * b[k - 1 + (j - 1) * ldb + _b_offset];
                                int i = 1;
                                int r = k - 1;
                                while (r > 0) {
                                    b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] + temp * a[i - 1 + (k - 1) * lda + _a_offset];
                                    ++i;
                                    --r;
                                }
                                if (nounit) {
                                    temp *= a[k - 1 + (k - 1) * lda + _a_offset];
                                }
                                b[k - 1 + (j - 1) * ldb + _b_offset] = temp;
                            }
                            ++k;
                            --q;
                        }
                        ++j;
                        --p;
                    }
                } else {
                    int j = 1;
                    int p = n;
                    while (p > 0) {
                        int k = m;
                        int q = m;
                        while (q > 0) {
                            if (b[k - 1 + (j - 1) * ldb + _b_offset] != 0.0) {
                                double temp;
                                b[k - 1 + (j - 1) * ldb + _b_offset] = temp = alpha * b[k - 1 + (j - 1) * ldb + _b_offset];
                                if (nounit) {
                                    b[k - 1 + (j - 1) * ldb + _b_offset] = b[k - 1 + (j - 1) * ldb + _b_offset] * a[k - 1 + (k - 1) * lda + _a_offset];
                                }
                                int i = k + 1;
                                int r = m - k;
                                while (r > 0) {
                                    b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] + temp * a[i - 1 + (k - 1) * lda + _a_offset];
                                    ++i;
                                    --r;
                                }
                            }
                            --k;
                            --q;
                        }
                        ++j;
                        --p;
                    }
                }
            } else if (upper) {
                int j = 1;
                int p = n;
                while (p > 0) {
                    int i = m;
                    int q = m;
                    while (q > 0) {
                        double temp = b[i - 1 + (j - 1) * ldb + _b_offset];
                        if (nounit) {
                            temp *= a[i - 1 + (i - 1) * lda + _a_offset];
                        }
                        int k = 1;
                        int r = i - 1;
                        while (r > 0) {
                            temp += a[k - 1 + (i - 1) * lda + _a_offset] * b[k - 1 + (j - 1) * ldb + _b_offset];
                            ++k;
                            --r;
                        }
                        b[i - 1 + (j - 1) * ldb + _b_offset] = alpha * temp;
                        --i;
                        --q;
                    }
                    ++j;
                    --p;
                }
            } else {
                int j = 1;
                int p = n;
                while (p > 0) {
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        double temp = b[i - 1 + (j - 1) * ldb + _b_offset];
                        if (nounit) {
                            temp *= a[i - 1 + (i - 1) * lda + _a_offset];
                        }
                        int k = i + 1;
                        int r = m - i;
                        while (r > 0) {
                            temp += a[k - 1 + (i - 1) * lda + _a_offset] * b[k - 1 + (j - 1) * ldb + _b_offset];
                            ++k;
                            --r;
                        }
                        b[i - 1 + (j - 1) * ldb + _b_offset] = alpha * temp;
                        ++i;
                        --q;
                    }
                    ++j;
                    --p;
                }
            }
        } else if (notrans) {
            if (upper) {
                int j = n;
                int p = n;
                while (p > 0) {
                    double temp = alpha;
                    if (nounit) {
                        temp *= a[j - 1 + (j - 1) * lda + _a_offset];
                    }
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        b[i - 1 + (j - 1) * ldb + _b_offset] = temp * b[i - 1 + (j - 1) * ldb + _b_offset];
                        ++i;
                        --q;
                    }
                    int k = 1;
                    int r = j - 1;
                    while (r > 0) {
                        if (a[k - 1 + (j - 1) * lda + _a_offset] != 0.0) {
                            temp = alpha * a[k - 1 + (j - 1) * lda + _a_offset];
                            int ii = 1;
                            int s = m;
                            while (s > 0) {
                                b[ii - 1 + (j - 1) * ldb + _b_offset] = b[ii - 1 + (j - 1) * ldb + _b_offset] + temp * b[ii - 1 + (k - 1) * ldb + _b_offset];
                                ++ii;
                                --s;
                            }
                        }
                        ++k;
                        --r;
                    }
                    --j;
                    --p;
                }
            } else {
                int j = 1;
                int p = n;
                while (p > 0) {
                    double temp = alpha;
                    if (nounit) {
                        temp *= a[j - 1 + (j - 1) * lda + _a_offset];
                    }
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        b[i - 1 + (j - 1) * ldb + _b_offset] = temp * b[i - 1 + (j - 1) * ldb + _b_offset];
                        ++i;
                        --q;
                    }
                    int k = j + 1;
                    int r = n - j;
                    while (r > 0) {
                        if (a[k - 1 + (j - 1) * lda + _a_offset] != 0.0) {
                            temp = alpha * a[k - 1 + (j - 1) * lda + _a_offset];
                            int ii = 1;
                            int s = m;
                            while (s > 0) {
                                b[ii - 1 + (j - 1) * ldb + _b_offset] = b[ii - 1 + (j - 1) * ldb + _b_offset] + temp * b[ii - 1 + (k - 1) * ldb + _b_offset];
                                ++ii;
                                --s;
                            }
                        }
                        ++k;
                        --r;
                    }
                    ++j;
                    --p;
                }
            }
        } else if (upper) {
            int k = 1;
            int p = n;
            while (p > 0) {
                int j = 1;
                int q = k - 1;
                while (q > 0) {
                    if (a[j - 1 + (k - 1) * lda + _a_offset] != 0.0) {
                        double temp = alpha * a[j - 1 + (k - 1) * lda + _a_offset];
                        int i = 1;
                        int r = m;
                        while (r > 0) {
                            b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] + temp * b[i - 1 + (k - 1) * ldb + _b_offset];
                            ++i;
                            --r;
                        }
                    }
                    ++j;
                    --q;
                }
                double temp = alpha;
                if (nounit) {
                    temp *= a[k - 1 + (k - 1) * lda + _a_offset];
                }
                if (temp != 1.0) {
                    int i = 1;
                    int s = m;
                    while (s > 0) {
                        b[i - 1 + (k - 1) * ldb + _b_offset] = temp * b[i - 1 + (k - 1) * ldb + _b_offset];
                        ++i;
                        --s;
                    }
                }
                ++k;
                --p;
            }
        } else {
            int k = n;
            int p = n;
            while (p > 0) {
                int j = k + 1;
                int q = n - k;
                while (q > 0) {
                    if (a[j - 1 + (k - 1) * lda + _a_offset] != 0.0) {
                        double temp = alpha * a[j - 1 + (k - 1) * lda + _a_offset];
                        int i = 1;
                        int r = m;
                        while (r > 0) {
                            b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] + temp * b[i - 1 + (k - 1) * ldb + _b_offset];
                            ++i;
                            --r;
                        }
                    }
                    ++j;
                    --q;
                }
                double temp = alpha;
                if (nounit) {
                    temp *= a[k - 1 + (k - 1) * lda + _a_offset];
                }
                if (temp != 1.0) {
                    int i = 1;
                    int s = m;
                    while (s > 0) {
                        b[i - 1 + (k - 1) * ldb + _b_offset] = temp * b[i - 1 + (k - 1) * ldb + _b_offset];
                        ++i;
                        --s;
                    }
                }
                --k;
                --p;
            }
        }
    }
}

