/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;

public final class Dtrmv {
    public static void dtrmv(String uplo, String trans, String diag, int n, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx) {
        int info = 0;
        if (!Lsame.lsame(uplo, "U") && !Lsame.lsame(uplo, "L")) {
            info = 1;
        } else if (!(Lsame.lsame(trans, "N") || Lsame.lsame(trans, "T") || Lsame.lsame(trans, "C"))) {
            info = 2;
        } else if (!Lsame.lsame(diag, "U") && !Lsame.lsame(diag, "N")) {
            info = 3;
        } else if (n < 0) {
            info = 4;
        } else if (lda < Math.max(1, n)) {
            info = 6;
        } else if (incx == 0) {
            info = 8;
        }
        if (info != 0) {
            Xerbla.xerbla("DTRMV ", info);
            return;
        }
        if (n == 0) {
            return;
        }
        boolean nounit = Lsame.lsame(diag, "N");
        int kx = 0;
        if (incx <= 0) {
            kx = 1 - (n - 1) * incx;
        } else if (incx != 1) {
            kx = 1;
        }
        if (Lsame.lsame(trans, "N")) {
            if (Lsame.lsame(uplo, "U")) {
                if (incx == 1) {
                    int j = 1;
                    int p = n;
                    while (p > 0) {
                        if (x[j - 1 + _x_offset] != 0.0) {
                            double temp = x[j - 1 + _x_offset];
                            int i = 1;
                            int q = j - 1;
                            while (q > 0) {
                                x[i - 1 + _x_offset] = x[i - 1 + _x_offset] + temp * a[i - 1 + (j - 1) * lda + _a_offset];
                                ++i;
                                --q;
                            }
                            if (nounit) {
                                x[j - 1 + _x_offset] = x[j - 1 + _x_offset] * a[j - 1 + (j - 1) * lda + _a_offset];
                            }
                        }
                        ++j;
                        --p;
                    }
                } else {
                    int jx = kx;
                    int j = 1;
                    int p = n;
                    while (p > 0) {
                        if (x[jx - 1 + _x_offset] != 0.0) {
                            double temp = x[jx - 1 + _x_offset];
                            int ix = kx;
                            int i = 1;
                            int q = j - 1;
                            while (q > 0) {
                                x[ix - 1 + _x_offset] = x[ix - 1 + _x_offset] + temp * a[i - 1 + (j - 1) * lda + _a_offset];
                                ix += incx;
                                ++i;
                                --q;
                            }
                            if (nounit) {
                                x[jx - 1 + _x_offset] = x[jx - 1 + _x_offset] * a[j - 1 + (j - 1) * lda + _a_offset];
                            }
                        }
                        jx += incx;
                        ++j;
                        --p;
                    }
                }
            } else if (incx == 1) {
                int j = n;
                int p = n;
                while (p > 0) {
                    if (x[j - 1 + _x_offset] != 0.0) {
                        double temp = x[j - 1 + _x_offset];
                        int i = n;
                        int q = n - j;
                        while (q > 0) {
                            x[i - 1 + _x_offset] = x[i - 1 + _x_offset] + temp * a[i - 1 + (j - 1) * lda + _a_offset];
                            --i;
                            --q;
                        }
                        if (nounit) {
                            x[j - 1 + _x_offset] = x[j - 1 + _x_offset] * a[j - 1 + (j - 1) * lda + _a_offset];
                        }
                    }
                    --j;
                    --p;
                }
            } else {
                int jx = kx += (n - 1) * incx;
                int j = n;
                int p = n;
                while (p > 0) {
                    if (x[jx - 1 + _x_offset] != 0.0) {
                        double temp = x[jx - 1 + _x_offset];
                        int ix = kx;
                        int i = n;
                        int q = n - j;
                        while (q > 0) {
                            x[ix - 1 + _x_offset] = x[ix - 1 + _x_offset] + temp * a[i - 1 + (j - 1) * lda + _a_offset];
                            ix -= incx;
                            --i;
                            --q;
                        }
                        if (nounit) {
                            x[jx - 1 + _x_offset] = x[jx - 1 + _x_offset] * a[j - 1 + (j - 1) * lda + _a_offset];
                        }
                    }
                    jx -= incx;
                    --j;
                    --p;
                }
            }
        } else if (Lsame.lsame(uplo, "U")) {
            if (incx == 1) {
                int j = n;
                int p = n;
                while (p > 0) {
                    double temp = x[j - 1 + _x_offset];
                    if (nounit) {
                        temp *= a[j - 1 + (j - 1) * lda + _a_offset];
                    }
                    int i = j - 1;
                    int q = j - 1;
                    while (q > 0) {
                        temp += a[i - 1 + (j - 1) * lda + _a_offset] * x[i - 1 + _x_offset];
                        --i;
                        --q;
                    }
                    x[j - 1 + _x_offset] = temp;
                    --j;
                    --p;
                }
            } else {
                int jx = kx + (n - 1) * incx;
                int j = n;
                int p = n;
                while (p > 0) {
                    double temp = x[jx - 1 + _x_offset];
                    int ix = jx;
                    if (nounit) {
                        temp *= a[j - 1 + (j - 1) * lda + _a_offset];
                    }
                    int i = j - 1;
                    int q = j - 1;
                    while (q > 0) {
                        temp += a[i - 1 + (j - 1) * lda + _a_offset] * x[(ix -= incx) - 1 + _x_offset];
                        --i;
                        --q;
                    }
                    x[jx - 1 + _x_offset] = temp;
                    jx -= incx;
                    --j;
                    --p;
                }
            }
        } else if (incx == 1) {
            int j = 1;
            int p = n;
            while (p > 0) {
                double temp = x[j - 1 + _x_offset];
                if (nounit) {
                    temp *= a[j - 1 + (j - 1) * lda + _a_offset];
                }
                int i = j + 1;
                int q = n - j;
                while (q > 0) {
                    temp += a[i - 1 + (j - 1) * lda + _a_offset] * x[i - 1 + _x_offset];
                    ++i;
                    --q;
                }
                x[j - 1 + _x_offset] = temp;
                ++j;
                --p;
            }
        } else {
            int jx = kx;
            int j = 1;
            int p = n;
            while (p > 0) {
                double temp = x[jx - 1 + _x_offset];
                int ix = jx;
                if (nounit) {
                    temp *= a[j - 1 + (j - 1) * lda + _a_offset];
                }
                int i = j + 1;
                int q = n - j;
                while (q > 0) {
                    temp += a[i - 1 + (j - 1) * lda + _a_offset] * x[(ix += incx) - 1 + _x_offset];
                    ++i;
                    --q;
                }
                x[jx - 1 + _x_offset] = temp;
                jx += incx;
                ++j;
                --p;
            }
        }
    }
}

