/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;

public final class Dtrsm {
    public static void dtrsm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb) {
        boolean lside = Lsame.lsame(side, "L");
        boolean upper = Lsame.lsame(uplo, "U");
        boolean notrans = Lsame.lsame(transa, "N");
        boolean nounit = Lsame.lsame(diag, "N");
        int info = 0;
        if (!lside && !Lsame.lsame(side, "R")) {
            info = 1;
        } else if (!upper && !Lsame.lsame(uplo, "L")) {
            info = 2;
        } else if (!(notrans || Lsame.lsame(transa, "T") || Lsame.lsame(transa, "C"))) {
            info = 3;
        } else if (!nounit && !Lsame.lsame(diag, "U")) {
            info = 4;
        } else if (m < 0) {
            info = 5;
        } else if (n < 0) {
            info = 6;
        } else if (lda < Math.max(1, lside ? m : n)) {
            info = 9;
        } else if (ldb < Math.max(1, m)) {
            info = 11;
        }
        if (info != 0) {
            Xerbla.xerbla("DTRSM ", info);
            return;
        }
        if (m == 0 || n == 0) {
            return;
        }
        if (alpha == 0.0) {
            int j = 1;
            int p = n;
            while (p > 0) {
                int i = 1;
                int q = m;
                while (q > 0) {
                    b[i - 1 + (j - 1) * ldb + _b_offset] = 0.0;
                    ++i;
                    --q;
                }
                ++j;
                --p;
            }
            return;
        }
        if (lside) {
            if (notrans) {
                if (upper) {
                    int j = 1;
                    int p = n;
                    while (p > 0) {
                        if (alpha != 1.0) {
                            int i = 1;
                            int q = m;
                            while (q > 0) {
                                b[i - 1 + (j - 1) * ldb + _b_offset] = alpha * b[i - 1 + (j - 1) * ldb + _b_offset];
                                ++i;
                                --q;
                            }
                        }
                        int k = m;
                        int r = m;
                        while (r > 0) {
                            if (b[k - 1 + (j - 1) * ldb + _b_offset] != 0.0) {
                                if (nounit) {
                                    b[k - 1 + (j - 1) * ldb + _b_offset] = b[k - 1 + (j - 1) * ldb + _b_offset] / a[k - 1 + (k - 1) * lda + _a_offset];
                                }
                                int i = 1;
                                int s = k - 1;
                                while (s > 0) {
                                    b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] - b[k - 1 + (j - 1) * ldb + _b_offset] * a[i - 1 + (k - 1) * lda + _a_offset];
                                    ++i;
                                    --s;
                                }
                            }
                            --k;
                            --r;
                        }
                        ++j;
                        --p;
                    }
                } else {
                    int j = 1;
                    int p = n;
                    while (p > 0) {
                        if (alpha != 1.0) {
                            int i = 1;
                            int q = m;
                            while (q > 0) {
                                b[i - 1 + (j - 1) * ldb + _b_offset] = alpha * b[i - 1 + (j - 1) * ldb + _b_offset];
                                ++i;
                                --q;
                            }
                        }
                        int k = 1;
                        int r = m;
                        while (r > 0) {
                            if (b[k - 1 + (j - 1) * ldb + _b_offset] != 0.0) {
                                if (nounit) {
                                    b[k - 1 + (j - 1) * ldb + _b_offset] = b[k - 1 + (j - 1) * ldb + _b_offset] / a[k - 1 + (k - 1) * lda + _a_offset];
                                }
                                int i = k + 1;
                                int s = m - k;
                                while (s > 0) {
                                    b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] - b[k - 1 + (j - 1) * ldb + _b_offset] * a[i - 1 + (k - 1) * lda + _a_offset];
                                    ++i;
                                    --s;
                                }
                            }
                            ++k;
                            --r;
                        }
                        ++j;
                        --p;
                    }
                }
            } else if (upper) {
                int j = 1;
                int p = n;
                while (p > 0) {
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        double temp = alpha * b[i - 1 + (j - 1) * ldb + _b_offset];
                        int k = 1;
                        int r = i - 1;
                        while (r > 0) {
                            temp -= a[k - 1 + (i - 1) * lda + _a_offset] * b[k - 1 + (j - 1) * ldb + _b_offset];
                            ++k;
                            --r;
                        }
                        if (nounit) {
                            temp /= a[i - 1 + (i - 1) * lda + _a_offset];
                        }
                        b[i - 1 + (j - 1) * ldb + _b_offset] = temp;
                        ++i;
                        --q;
                    }
                    ++j;
                    --p;
                }
            } else {
                int j = 1;
                int p = n;
                while (p > 0) {
                    int i = m;
                    int q = m;
                    while (q > 0) {
                        double temp = alpha * b[i - 1 + (j - 1) * ldb + _b_offset];
                        int k = i + 1;
                        int r = m - i;
                        while (r > 0) {
                            temp -= a[k - 1 + (i - 1) * lda + _a_offset] * b[k - 1 + (j - 1) * ldb + _b_offset];
                            ++k;
                            --r;
                        }
                        if (nounit) {
                            temp /= a[i - 1 + (i - 1) * lda + _a_offset];
                        }
                        b[i - 1 + (j - 1) * ldb + _b_offset] = temp;
                        --i;
                        --q;
                    }
                    ++j;
                    --p;
                }
            }
        } else if (notrans) {
            if (upper) {
                int j = 1;
                int p = n;
                while (p > 0) {
                    if (alpha != 1.0) {
                        int i = 1;
                        int q = m;
                        while (q > 0) {
                            b[i - 1 + (j - 1) * ldb + _b_offset] = alpha * b[i - 1 + (j - 1) * ldb + _b_offset];
                            ++i;
                            --q;
                        }
                    }
                    int k = 1;
                    int q = j - 1;
                    while (q > 0) {
                        if (a[k - 1 + (j - 1) * lda + _a_offset] != 0.0) {
                            int i = 1;
                            int r = m;
                            while (r > 0) {
                                b[i - 1 + (j - 1) * ldb + _b_offset] = b[i - 1 + (j - 1) * ldb + _b_offset] - a[k - 1 + (j - 1) * lda + _a_offset] * b[i - 1 + (k - 1) * ldb + _b_offset];
                                ++i;
                                --r;
                            }
                        }
                        ++k;
                        --q;
                    }
                    if (nounit) {
                        double temp = 1.0 / a[j - 1 + (j - 1) * lda + _a_offset];
                        int i = 1;
                        int s = m;
                        while (s > 0) {
                            b[i - 1 + (j - 1) * ldb + _b_offset] = temp * b[i - 1 + (j - 1) * ldb + _b_offset];
                            ++i;
                            --s;
                        }
                    }
                    ++j;
                    --p;
                }
            } else {
                int j = n;
                int p = n;
                while (p > 0) {
                    if (alpha != 1.0) {
                        int i = 1;
                        int q = m;
                        while (q > 0) {
                            b[i - 1 + (j - 1) * ldb + _b_offset] = alpha * b[i - 1 + (j - 1) * ldb + _b_offset];
                            ++i;
                            --q;
                        }
                    }
                    int k = j + 1;
                    int r = n - j;
                    while (r > 0) {
                        if (a[k - 1 + (j - 1) * lda + _a_offset] != 0.0) {
                            int ii = 1;
                            int s = m;
                            while (s > 0) {
                                b[ii - 1 + (j - 1) * ldb + _b_offset] = b[ii - 1 + (j - 1) * ldb + _b_offset] - a[k - 1 + (j - 1) * lda + _a_offset] * b[ii - 1 + (k - 1) * ldb + _b_offset];
                                ++ii;
                                --s;
                            }
                        }
                        ++k;
                        --r;
                    }
                    if (nounit) {
                        double temp = 1.0 / a[j - 1 + (j - 1) * lda + _a_offset];
                        int i = 1;
                        int s = m;
                        while (s > 0) {
                            b[i - 1 + (j - 1) * ldb + _b_offset] = temp * b[i - 1 + (j - 1) * ldb + _b_offset];
                            ++i;
                            --s;
                        }
                    }
                    --j;
                    --p;
                }
            }
        } else if (upper) {
            int k = n;
            int p = n;
            while (p > 0) {
                if (nounit) {
                    double temp = 1.0 / a[k - 1 + (k - 1) * lda + _a_offset];
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        b[i - 1 + (k - 1) * ldb + _b_offset] = temp * b[i - 1 + (k - 1) * ldb + _b_offset];
                        ++i;
                        --q;
                    }
                }
                int j = 1;
                int r = k - 1;
                while (r > 0) {
                    if (a[j - 1 + (k - 1) * lda + _a_offset] != 0.0) {
                        double temp = a[j - 1 + (k - 1) * lda + _a_offset];
                        int ii = 1;
                        int s = m;
                        while (s > 0) {
                            b[ii - 1 + (j - 1) * ldb + _b_offset] = b[ii - 1 + (j - 1) * ldb + _b_offset] - temp * b[ii - 1 + (k - 1) * ldb + _b_offset];
                            ++ii;
                            --s;
                        }
                    }
                    ++j;
                    --r;
                }
                if (alpha != 1.0) {
                    int i = 1;
                    int s = m;
                    while (s > 0) {
                        b[i - 1 + (k - 1) * ldb + _b_offset] = alpha * b[i - 1 + (k - 1) * ldb + _b_offset];
                        ++i;
                        --s;
                    }
                }
                --k;
                --p;
            }
        } else {
            int k = 1;
            int p = n;
            while (p > 0) {
                if (nounit) {
                    double temp = 1.0 / a[k - 1 + (k - 1) * lda + _a_offset];
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        b[i - 1 + (k - 1) * ldb + _b_offset] = temp * b[i - 1 + (k - 1) * ldb + _b_offset];
                        ++i;
                        --q;
                    }
                }
                int j = k + 1;
                int r = n - k;
                while (r > 0) {
                    if (a[j - 1 + (k - 1) * lda + _a_offset] != 0.0) {
                        double temp = a[j - 1 + (k - 1) * lda + _a_offset];
                        int ii = 1;
                        int s = m;
                        while (s > 0) {
                            b[ii - 1 + (j - 1) * ldb + _b_offset] = b[ii - 1 + (j - 1) * ldb + _b_offset] - temp * b[ii - 1 + (k - 1) * ldb + _b_offset];
                            ++ii;
                            --s;
                        }
                    }
                    ++j;
                    --r;
                }
                if (alpha != 1.0) {
                    int i = 1;
                    int s = m;
                    while (s > 0) {
                        b[i - 1 + (k - 1) * ldb + _b_offset] = alpha * b[i - 1 + (k - 1) * ldb + _b_offset];
                        ++i;
                        --s;
                    }
                }
                ++k;
                --p;
            }
        }
    }
}

