/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import java.util.Arrays;
import org.netlib.blas.Geaxpy;
import org.netlib.blas.Gescal;

final class Ugemm {
    static void ugemm(int mr, int nr, int kc, double alpha, int A_start, double[] A, int B_start, double[] B, double beta, int C_start, double[] C, int incRowC, int incColC, double[] AB, double[] workC) {
        Ugemm.ugemm(kc, alpha, A_start, A, B_start, B, 0.0, 0, workC, 1, 4, AB);
        Gescal.gescal(mr, nr, beta, C_start, C, incRowC, incColC);
        Geaxpy.geaxpy(mr, nr, 1.0, 0, workC, 1, 4, C_start, C, incRowC, incColC);
    }

    static void ugemm(int kc, double alpha, int A_start, double[] A, int B_start, double[] B, double beta, int C_start, double[] C, int incRowC, int incColC, double[] AB) {
        Arrays.fill(AB, 0.0);
        int l = 0;
        while (l < kc) {
            double b0j = B[B_start++];
            double b1j = B[B_start++];
            double b2j = B[B_start++];
            double b3j = B[B_start++];
            double a0i = A[A_start++];
            double a1i = A[A_start++];
            double a2i = A[A_start++];
            double a3i = A[A_start++];
            int idx = 0;
            int n = idx++;
            AB[n] = AB[n] + a0i * b0j;
            int n2 = idx++;
            AB[n2] = AB[n2] + a1i * b0j;
            int n3 = idx++;
            AB[n3] = AB[n3] + a2i * b0j;
            int n4 = idx++;
            AB[n4] = AB[n4] + a3i * b0j;
            int n5 = idx++;
            AB[n5] = AB[n5] + a0i * b1j;
            int n6 = idx++;
            AB[n6] = AB[n6] + a1i * b1j;
            int n7 = idx++;
            AB[n7] = AB[n7] + a2i * b1j;
            int n8 = idx++;
            AB[n8] = AB[n8] + a3i * b1j;
            int n9 = idx++;
            AB[n9] = AB[n9] + a0i * b2j;
            int n10 = idx++;
            AB[n10] = AB[n10] + a1i * b2j;
            int n11 = idx++;
            AB[n11] = AB[n11] + a2i * b2j;
            int n12 = idx++;
            AB[n12] = AB[n12] + a3i * b2j;
            int n13 = idx++;
            AB[n13] = AB[n13] + a0i * b3j;
            int n14 = idx++;
            AB[n14] = AB[n14] + a1i * b3j;
            int n15 = idx++;
            AB[n15] = AB[n15] + a2i * b3j;
            int n16 = idx++;
            AB[n16] = AB[n16] + a3i * b3j;
            ++l;
        }
        if (beta != 1.0) {
            Ugemm.betaMulC(beta, C_start, C, incRowC, incColC);
        }
        Ugemm.plusAlphaAB(alpha, C_start, C, incRowC, incColC, AB);
    }

    private static void betaMulC(double beta, int C_start, double[] C, int incRowC, int incColC) {
        if (beta == 0.0) {
            int j = 0;
            while (j < 4) {
                int base_C = C_start + j * incColC;
                int i = 0;
                while (i < 4) {
                    C[base_C + i * incRowC] = 0.0;
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < 4) {
                int base_C = C_start + j * incColC;
                int i = 0;
                while (i < 4) {
                    int n = base_C + i * incRowC;
                    C[n] = C[n] * beta;
                    ++i;
                }
                ++j;
            }
        }
    }

    private static void plusAlphaAB(double alpha, int C_start, double[] C, int incRowC, int incColC, double[] AB) {
        if (alpha == 1.0) {
            int j = 0;
            while (j < 4) {
                int jIdx = j * 4;
                int base_C = C_start + j * incColC;
                int i = 0;
                while (i < 4) {
                    int n = base_C + i * incRowC;
                    C[n] = C[n] + AB[i + jIdx];
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < 4) {
                int jIdx = j * 4;
                int base_C = C_start + j * incColC;
                int i = 0;
                while (i < 4) {
                    int n = base_C + i * incRowC;
                    C[n] = C[n] + alpha * AB[i + jIdx];
                    ++i;
                }
                ++j;
            }
        }
    }

    private Ugemm() {
        throw new AssertionError();
    }
}

