/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.err.Xerbla;
import org.netlib.lapack.Dlarf;
import org.netlib.lapack.Dlarfg;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public final class Dgelq2 {
    public static void dgelq2(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, intW info) {
        info.val = 0;
        if (m < 0) {
            info.val = -1;
        } else if (n < 0) {
            info.val = -2;
        } else if (lda < Math.max(1, m)) {
            info.val = -4;
        }
        if (info.val != 0) {
            Xerbla.xerbla("DGELQ2", -info.val);
            return;
        }
        int k = Math.min(m, n);
        doubleW a1Val = new doubleW(0.0);
        doubleW tauVal = new doubleW(0.0);
        int i = 1;
        int p = k;
        while (p > 0) {
            Dgelq2.dlarfg_adapter(n - i + 1, a, i - 1 + (i - 1) * lda + _a_offset, a, i - 1 + (Math.min(i + 1, n) - 1) * lda + _a_offset, lda, tau, i - 1 + _tau_offset, a1Val, tauVal);
            if (i < m) {
                double aii = a[i - 1 + (i - 1) * lda + _a_offset];
                a[i - 1 + (i - 1) * lda + _a_offset] = 1.0;
                Dlarf.dlarf("Right", m - i, n - i + 1, a, i - 1 + (i - 1) * lda + _a_offset, lda, tau[i - 1 + _tau_offset], a, i + (i - 1) * lda + _a_offset, lda, work, _work_offset);
                a[i - 1 + (i - 1) * lda + _a_offset] = aii;
            }
            ++i;
            --p;
        }
    }

    private static void dlarfg_adapter(int i, double[] a1, int idxA1, double[] a2, int off, int inc, double[] tau, int idxTau, doubleW a1Val, doubleW tauVal) {
        a1Val.val = a1[idxA1];
        tauVal.val = tau[idxTau];
        Dlarfg.dlarfg(i, a1Val, a2, off, inc, tauVal);
        a1[idxA1] = a1Val.val;
        tau[idxTau] = tauVal.val;
    }
}

