/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.err.Xerbla;
import org.netlib.lapack.Dgelq2;
import org.netlib.lapack.Dlarfb;
import org.netlib.lapack.Dlarft;
import org.netlib.lapack.Ilaenv;
import org.netlib.util.intW;

public final class Dgelqf {
    private static final intW refInfo = new intW(0);

    public static void dgelqf(int m, int n, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] work, int _work_offset, int lwork, intW info) {
        boolean lquery;
        info.val = 0;
        int nb = Ilaenv.ilaenv(1, "DGELQF", " ", m, n, -1, -1);
        int lwkopt = m * nb;
        work[_work_offset] = lwkopt;
        boolean bl = lquery = lwork == -1;
        if (m < 0) {
            info.val = -1;
        } else if (n < 0) {
            info.val = -2;
        } else if (lda < Math.max(1, m)) {
            info.val = -4;
        } else if (!lquery && lwork < Math.max(1, m)) {
            info.val = -7;
        }
        if (info.val != 0) {
            Xerbla.xerbla("DGELQF", -info.val);
            return;
        }
        if (lquery) {
            return;
        }
        int k = Math.min(m, n);
        if (k == 0) {
            work[_work_offset] = 1.0;
            return;
        }
        int nbmin = 2;
        int nx = 0;
        int ldwork = 0;
        int iws = m;
        if (nb > 1 && nb < k && (nx = Math.max(0, Ilaenv.ilaenv(3, "DGELQF", " ", m, n, -1, -1))) < k && lwork < (iws = (ldwork = m) * nb)) {
            nb = lwork / ldwork;
            nbmin = Math.max(2, Ilaenv.ilaenv(2, "DGELQF", " ", m, n, -1, -1));
        }
        int i = 0;
        if (nb >= nbmin && nb < k && nx < k) {
            i = 1;
            int p = (k - nx - 1 + nb) / nb;
            while (p > 0) {
                int ib = Math.min(k - i + 1, nb);
                Dgelq2.dgelq2(ib, n - i + 1, a, i - 1 + (i - 1) * lda + _a_offset, lda, tau, i - 1 + _tau_offset, work, _work_offset, refInfo);
                if (i + ib <= m) {
                    Dlarft.dlarft("Forward", "Rowwise", n - i + 1, ib, a, i - 1 + (i - 1) * lda + _a_offset, lda, tau, i - 1 + _tau_offset, work, _work_offset, ldwork);
                    Dlarfb.dlarfb("Right", "No transpose", "Forward", "Rowwise", m - i - ib + 1, n - i + 1, ib, a, i - 1 + (i - 1) * lda + _a_offset, lda, work, _work_offset, ldwork, a, i + ib - 1 + (i - 1) * lda + _a_offset, lda, work, ib + _work_offset, ldwork);
                }
                i += nb;
                --p;
            }
        } else {
            i = 1;
        }
        if (i <= k) {
            Dgelq2.dgelq2(m - i + 1, n - i + 1, a, i - 1 + (i - 1) * lda + _a_offset, lda, tau, i - 1 + _tau_offset, work, _work_offset, refInfo);
        }
        work[_work_offset] = iws;
    }
}

