/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;
import org.netlib.lapack.Dgelqf;
import org.netlib.lapack.Dgeqrf;
import org.netlib.lapack.Dlange;
import org.netlib.lapack.Dlascl;
import org.netlib.lapack.Dlaset;
import org.netlib.lapack.Dormlq;
import org.netlib.lapack.Dormqr;
import org.netlib.lapack.Dtrtrs;
import org.netlib.lapack.Ilaenv;
import org.netlib.util.Util;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public final class Dgels {
    public static void dgels(String trans, int m, int n, int nrhs, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double[] work, int _work_offset, int lwork, intW info) {
        boolean lquery;
        info.val = 0;
        int mn = Math.min(m, n);
        boolean bl = lquery = lwork == -1;
        if (!Lsame.lsame(trans, "N") && !Lsame.lsame(trans, "T")) {
            info.val = -1;
        } else if (m < 0) {
            info.val = -2;
        } else if (n < 0) {
            info.val = -3;
        } else if (nrhs < 0) {
            info.val = -4;
        } else if (lda < Math.max(1, m)) {
            info.val = -6;
        } else if (ldb < Util.max(1, m, n)) {
            info.val = -8;
        } else if (!lquery && lwork < Math.max(1, mn + Math.max(mn, nrhs))) {
            info.val = -10;
        }
        int wsize = 0;
        boolean tpsd = false;
        if (info.val == 0 || info.val == -10) {
            int nb;
            tpsd = true;
            if (Lsame.lsame(trans, "N")) {
                tpsd = false;
            }
            if (m >= n) {
                nb = Ilaenv.ilaenv(1, "DGEQRF", " ", m, n, -1, -1);
                nb = tpsd ? Math.max(nb, Ilaenv.ilaenv(1, "DORMQR", "LN", m, nrhs, n, -1)) : Math.max(nb, Ilaenv.ilaenv(1, "DORMQR", "LT", m, nrhs, n, -1));
            } else {
                nb = Ilaenv.ilaenv(1, "DGELQF", " ", m, n, -1, -1);
                nb = tpsd ? Math.max(nb, Ilaenv.ilaenv(1, "DORMLQ", "LT", n, nrhs, m, -1)) : Math.max(nb, Ilaenv.ilaenv(1, "DORMLQ", "LN", n, nrhs, m, -1));
            }
            wsize = Math.max(1, mn + Math.max(mn, nrhs) * nb);
            work[_work_offset] = wsize;
        }
        if (info.val != 0) {
            Xerbla.xerbla("DGELS ", -info.val);
            return;
        }
        if (lquery) {
            return;
        }
        if (Util.min(m, n, nrhs) == 0) {
            Dlaset.dlaset("Full", Math.max(m, n), nrhs, 0.0, 0.0, b, _b_offset, ldb);
            return;
        }
        doubleW smlnum = new doubleW(1.0020841800044864E-292);
        doubleW bignum = new doubleW(9.9792015476736E291);
        double[] rwork = new double[1];
        double anrm = Dlange.dlange("M", m, n, a, _a_offset, lda, rwork, 0);
        int iascl = 0;
        if (anrm > 0.0 && anrm < smlnum.val) {
            Dlascl.dlascl("G", 0, 0, anrm, smlnum.val, m, n, a, _a_offset, lda, info);
            iascl = 1;
        } else if (anrm > bignum.val) {
            Dlascl.dlascl("G", 0, 0, anrm, bignum.val, m, n, a, _a_offset, lda, info);
            iascl = 2;
        } else if (anrm == 0.0) {
            Dlaset.dlaset("F", Math.max(m, n), nrhs, 0.0, 0.0, b, _b_offset, ldb);
            work[_work_offset] = wsize;
            return;
        }
        int brow = m;
        if (tpsd) {
            brow = n;
        }
        double bnrm = Dlange.dlange("M", brow, nrhs, b, _b_offset, ldb, rwork, 0);
        int ibscl = 0;
        if (bnrm > 0.0 && bnrm < smlnum.val) {
            Dlascl.dlascl("G", 0, 0, bnrm, smlnum.val, brow, nrhs, b, _b_offset, ldb, info);
            ibscl = 1;
        } else if (bnrm > bignum.val) {
            Dlascl.dlascl("G", 0, 0, bnrm, bignum.val, brow, nrhs, b, _b_offset, ldb, info);
            ibscl = 2;
        }
        int scllen = 0;
        if (m >= n) {
            Dgeqrf.dgeqrf(m, n, a, _a_offset, lda, work, _work_offset, work, mn + _work_offset, lwork - mn, info);
            if (!tpsd) {
                Dormqr.dormqr("Left", "Transpose", m, nrhs, n, a, _a_offset, lda, work, _work_offset, b, _b_offset, ldb, work, mn + _work_offset, lwork - mn, info);
                Dtrtrs.dtrtrs("Upper", "No transpose", "Non-unit", n, nrhs, a, _a_offset, lda, b, _b_offset, ldb, info);
                if (info.val > 0) {
                    return;
                }
                scllen = n;
            } else {
                Dtrtrs.dtrtrs("Upper", "Transpose", "Non-unit", n, nrhs, a, _a_offset, lda, b, _b_offset, ldb, info);
                if (info.val > 0) {
                    return;
                }
                int j = 1;
                int p = nrhs;
                while (p > 0) {
                    int i = n + 1;
                    int q = m - n;
                    while (q > 0) {
                        b[i - 1 + (j - 1) * ldb + _b_offset] = 0.0;
                        ++i;
                        --q;
                    }
                    ++j;
                    --p;
                }
                Dormqr.dormqr("Left", "No transpose", m, nrhs, n, a, _a_offset, lda, work, _work_offset, b, _b_offset, ldb, work, mn + _work_offset, lwork - mn, info);
                scllen = m;
            }
        } else {
            Dgelqf.dgelqf(m, n, a, _a_offset, lda, work, _work_offset, work, mn + _work_offset, lwork - mn, info);
            if (!tpsd) {
                Dtrtrs.dtrtrs("Lower", "No transpose", "Non-unit", m, nrhs, a, _a_offset, lda, b, _b_offset, ldb, info);
                if (info.val > 0) {
                    return;
                }
                int j = 1;
                int p = nrhs;
                while (p > 0) {
                    int i = m + 1;
                    int q = n - m;
                    while (q > 0) {
                        b[i - 1 + (j - 1) * ldb + _b_offset] = 0.0;
                        ++i;
                        --q;
                    }
                    ++j;
                    --p;
                }
                Dormlq.dormlq("Left", "Transpose", n, nrhs, m, a, _a_offset, lda, work, _work_offset, b, _b_offset, ldb, work, mn + _work_offset, lwork - mn, info);
                scllen = n;
            } else {
                Dormlq.dormlq("Left", "No transpose", n, nrhs, m, a, _a_offset, lda, work, _work_offset, b, _b_offset, ldb, work, mn + _work_offset, lwork - mn, info);
                Dtrtrs.dtrtrs("Lower", "Transpose", "Non-unit", m, nrhs, a, _a_offset, lda, b, _b_offset, ldb, info);
                if (info.val > 0) {
                    return;
                }
                scllen = m;
            }
        }
        if (iascl == 1) {
            Dlascl.dlascl("G", 0, 0, anrm, smlnum.val, scllen, nrhs, b, _b_offset, ldb, info);
        } else if (iascl == 2) {
            Dlascl.dlascl("G", 0, 0, anrm, bignum.val, scllen, nrhs, b, _b_offset, ldb, info);
        }
        if (ibscl == 1) {
            Dlascl.dlascl("G", 0, 0, smlnum.val, bnrm, scllen, nrhs, b, _b_offset, ldb, info);
        } else if (ibscl == 2) {
            Dlascl.dlascl("G", 0, 0, bignum.val, bnrm, scllen, nrhs, b, _b_offset, ldb, info);
        }
        work[_work_offset] = wsize;
    }
}

