/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dger;
import org.netlib.blas.Dscal;
import org.netlib.blas.Dswap;
import org.netlib.blas.Idamax;
import org.netlib.err.Xerbla;
import org.netlib.util.intW;

public final class Dgetf2 {
    public static void dgetf2(int m, int n, double[] a, int _a_offset, int lda, int[] ipiv, int _ipiv_offset, intW info) {
        info.val = 0;
        if (m < 0) {
            info.val = -1;
        } else if (n < 0) {
            info.val = -2;
        } else if (lda < Math.max(1, m)) {
            info.val = -4;
        }
        if (info.val != 0) {
            Xerbla.xerbla("DGETF2", -info.val);
            return;
        }
        if (m == 0 || n == 0) {
            return;
        }
        int j = 1;
        int p = Math.min(m, n);
        while (p > 0) {
            int jp;
            ipiv[j - 1 + _ipiv_offset] = jp = j - 1 + Idamax.idamax(m - j + 1, a, j - 1 + (j - 1) * lda + _a_offset, 1);
            if (a[jp - 1 + (j - 1) * lda + _a_offset] != 0.0) {
                if (jp != j) {
                    Dswap.dswap(n, a, j - 1 + _a_offset, lda, a, jp - 1 + _a_offset, lda);
                }
                if (j < m) {
                    if (Math.abs(a[j - 1 + (j - 1) * lda + _a_offset]) >= Double.MIN_NORMAL) {
                        Dscal.dscal(m - j, 1.0 / a[j - 1 + (j - 1) * lda + _a_offset], a, j + (j - 1) * lda + _a_offset, 1);
                    } else {
                        int i = 1;
                        int q = m - j;
                        while (q > 0) {
                            a[j + i - 1 + (j - 1) * lda + _a_offset] = a[j + i - 1 + (j - 1) * lda + _a_offset] / a[j - 1 + (j - 1) * lda + _a_offset];
                            ++i;
                            --q;
                        }
                    }
                }
            } else if (info.val == 0) {
                info.val = j;
            }
            if (j < Math.min(m, n)) {
                Dger.dger(m - j, n - j, -1.0, a, j + (j - 1) * lda + _a_offset, 1, a, j - 1 + j * lda + _a_offset, lda, a, j + j * lda + _a_offset, lda);
            }
            ++j;
            --p;
        }
    }
}

