/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Lsame;
import org.netlib.lapack.Dlassq;
import org.netlib.util.doubleW;

public final class Dlange {
    public static double dlange(String norm, int m, int n, double[] a, int _a_offset, int lda, double[] work, int _work_offset) {
        double value = 0.0;
        if (Math.min(m, n) == 0) {
            value = 0.0;
        } else if (Lsame.lsame(norm, "M")) {
            value = 0.0;
            int j = 1;
            int p = n;
            while (p > 0) {
                int i = 1;
                int q = m;
                while (q > 0) {
                    value = Math.max(value, Math.abs(a[i - 1 + (j - 1) * lda + _a_offset]));
                    ++i;
                    --q;
                }
                ++j;
                --p;
            }
        } else if (Lsame.lsame(norm, "O") || norm.regionMatches(0, "1", 0, 1)) {
            value = 0.0;
            int j = 1;
            int p = n;
            while (p > 0) {
                double sum = 0.0;
                int i = 1;
                int q = m;
                while (q > 0) {
                    sum += Math.abs(a[i - 1 + (j - 1) * lda + _a_offset]);
                    ++i;
                    --q;
                }
                value = Math.max(value, sum);
                ++j;
                --p;
            }
        } else if (Lsame.lsame(norm, "I")) {
            int i = 1;
            int p = m;
            while (p > 0) {
                work[i - 1 + _work_offset] = 0.0;
                ++i;
                --p;
            }
            int j = 1;
            int p2 = n;
            while (p2 > 0) {
                i = 1;
                int q = m;
                while (q > 0) {
                    work[i - 1 + _work_offset] = work[i - 1 + _work_offset] + Math.abs(a[i - 1 + (j - 1) * lda + _a_offset]);
                    ++i;
                    --q;
                }
                ++j;
                --p2;
            }
            value = 0.0;
            i = 1;
            p2 = m;
            while (p2 > 0) {
                value = Math.max(value, work[i - 1 + _work_offset]);
                ++i;
                --p2;
            }
        } else if (Lsame.lsame(norm, "F") || Lsame.lsame(norm, "E")) {
            doubleW scale = new doubleW(0.0);
            doubleW sum = new doubleW(1.0);
            int j = 1;
            int p = n;
            while (p > 0) {
                Dlassq.dlassq(m, a, (j - 1) * lda + _a_offset, 1, scale, sum);
                ++j;
                --p;
            }
            value = scale.val * Math.sqrt(sum.val);
        }
        return value;
    }
}

