/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;
import org.netlib.util.intW;

public final class Dlascl {
    public static void dlascl(String type, int kl, int ku, double cfrom, double cto, int m, int n, double[] a, int _a_offset, int lda, intW info) {
        info.val = 0;
        int itype = 0;
        itype = Lsame.lsame(type, "G") ? 0 : (Lsame.lsame(type, "L") ? 1 : (Lsame.lsame(type, "U") ? 2 : (Lsame.lsame(type, "H") ? 3 : (Lsame.lsame(type, "B") ? 4 : (Lsame.lsame(type, "Q") ? 5 : (Lsame.lsame(type, "Z") ? 6 : -1))))));
        if (itype == -1) {
            info.val = -1;
        } else if (cfrom == 0.0) {
            info.val = -4;
        } else if (m < 0) {
            info.val = -6;
        } else if (n < 0 || itype == 4 && n != m || itype == 5 && n != m) {
            info.val = -7;
        } else if (itype <= 3 && lda < Math.max(1, m)) {
            info.val = -9;
        } else if (itype >= 4) {
            if (kl < 0 || kl > Math.max(m - 1, 0)) {
                info.val = -2;
            } else if (ku < 0 || ku > Math.max(n - 1, 0) || (itype == 4 || itype == 5) && kl != ku) {
                info.val = -3;
            } else if (itype == 4 && lda < kl + 1 || itype == 5 && lda < ku + 1 || itype == 6 && lda < 2 * kl + ku + 1) {
                info.val = -9;
            }
        }
        if (info.val != 0) {
            Xerbla.xerbla("DLASCL", -info.val);
            return;
        }
        if (n == 0 || m == 0) {
            return;
        }
        boolean done = false;
        double smlnum = Double.MIN_NORMAL;
        double bignum = 4.49423283715579E307;
        double cfromc = cfrom;
        double ctoc = cto;
        do {
            int k1;
            int q;
            int i;
            int p;
            int j;
            int q2;
            int i2;
            int p2;
            int j2;
            double mul;
            double cfrom1 = cfromc * Double.MIN_NORMAL;
            double cto1 = ctoc / 4.49423283715579E307;
            if (Math.abs(cfrom1) > Math.abs(ctoc) && ctoc != 0.0) {
                mul = Double.MIN_NORMAL;
                done = false;
                cfromc = cfrom1;
            } else if (Math.abs(cto1) > Math.abs(cfromc)) {
                mul = 4.49423283715579E307;
                done = false;
                ctoc = cto1;
            } else {
                mul = ctoc / cfromc;
                done = true;
            }
            if (itype == 0) {
                j2 = 1;
                p2 = n;
                while (p2 > 0) {
                    i2 = 1;
                    q2 = m;
                    while (q2 > 0) {
                        a[i2 - 1 + (j2 - 1) * lda + _a_offset] = a[i2 - 1 + (j2 - 1) * lda + _a_offset] * mul;
                        ++i2;
                        --q2;
                    }
                    ++j2;
                    --p2;
                }
            } else if (itype == 1) {
                j2 = 1;
                p2 = n;
                while (p2 > 0) {
                    i2 = j2;
                    q2 = m - j2 + 1;
                    while (q2 > 0) {
                        a[i2 - 1 + (j2 - 1) * lda + _a_offset] = a[i2 - 1 + (j2 - 1) * lda + _a_offset] * mul;
                        ++i2;
                        --q2;
                    }
                    ++j2;
                    --p2;
                }
            } else if (itype == 2) {
                j2 = 1;
                p2 = n;
                while (p2 > 0) {
                    i2 = 1;
                    q2 = Math.min(j2, m);
                    while (q2 > 0) {
                        a[i2 - 1 + (j2 - 1) * lda + _a_offset] = a[i2 - 1 + (j2 - 1) * lda + _a_offset] * mul;
                        ++i2;
                        --q2;
                    }
                    ++j2;
                    --p2;
                }
            } else if (itype == 3) {
                j2 = 1;
                p2 = n;
                while (p2 > 0) {
                    i2 = 1;
                    q2 = Math.min(j2 + 1, m);
                    while (q2 > 0) {
                        a[i2 - 1 + (j2 - 1) * lda + _a_offset] = a[i2 - 1 + (j2 - 1) * lda + _a_offset] * mul;
                        ++i2;
                        --q2;
                    }
                    ++j2;
                    --p2;
                }
            } else if (itype == 4) {
                int k3 = kl + 1;
                int k4 = n + 1;
                j = 1;
                p = n;
                while (p > 0) {
                    i = 1;
                    q = Math.min(k3, k4 - j);
                    while (q > 0) {
                        a[i - 1 + (j - 1) * lda + _a_offset] = a[i - 1 + (j - 1) * lda + _a_offset] * mul;
                        ++i;
                        --q;
                    }
                    ++j;
                    --p;
                }
            } else if (itype == 5) {
                k1 = ku + 2;
                int k3 = ku + 1;
                j = 1;
                p = n;
                while (p > 0) {
                    i = Math.max(k1 - j, 1);
                    q = k3 - Math.max(k1 - j, 1) + 1;
                    while (q > 0) {
                        a[i - 1 + (j - 1) * lda + _a_offset] = a[i - 1 + (j - 1) * lda + _a_offset] * mul;
                        ++i;
                        --q;
                    }
                    ++j;
                    --p;
                }
            } else {
                if (itype != 6) continue;
                k1 = kl + ku + 2;
                int k2 = kl + 1;
                int k3 = 2 * kl + ku + 1;
                int k4 = kl + ku + 1 + m;
                int j3 = 1;
                int p3 = n;
                while (p3 > 0) {
                    int i3 = Math.max(k1 - j3, k2);
                    int q3 = Math.min(k3, k4 - j3) - Math.max(k1 - j3, k2) + 1;
                    while (q3 > 0) {
                        a[i3 - 1 + (j3 - 1) * lda + _a_offset] = a[i3 - 1 + (j3 - 1) * lda + _a_offset] * mul;
                        ++i3;
                        --q3;
                    }
                    ++j3;
                    --p3;
                }
            }
        } while (!done);
    }
}

