/*
 * Decompiled with CFR 0.152.
 */
package rx.testkit;

import io.reactivex.Observable;
import io.reactivex.observers.TestObserver;
import io.reactivex.schedulers.TestScheduler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;

public class AssertObservable<T>
extends AbstractAssert<AssertObservable<T>, Observable<T>> {
    private final TestObserver<T> subscriber = new TestObserver();
    private TestScheduler scheduler;

    private AssertObservable(Observable<T> observable) {
        super(observable, AssertObservable.class);
        observable.subscribe(this.subscriber);
    }

    private AssertObservable(Observable<T> observable, TestScheduler scheduler) {
        this(observable);
        this.scheduler = scheduler;
    }

    public static <T> AssertObservable<T> assertThat(Observable<T> observable) {
        return new AssertObservable<T>(observable);
    }

    public static <T> AssertObservable<T> assertThat(Observable<T> observable, TestScheduler scheduler) {
        return new AssertObservable<T>(observable, scheduler);
    }

    public AssertObservable<T> hasCompleted() {
        this.subscriber.assertTerminated();
        return this;
    }

    public AssertObservable<T> hasNotCompleted() {
        this.subscriber.assertNotTerminated();
        return this;
    }

    public AbstractListAssert<?, ? extends List<? extends T>, T> values() {
        List onNextEvents = this.subscriber.values();
        return Assertions.assertThat((List)onNextEvents);
    }

    public AbstractListAssert<?, ? extends List<? extends Throwable>, Throwable> failures() {
        return Assertions.assertThat((List)this.subscriber.errors());
    }

    public AssertObservable<T> after(long duration, TimeUnit timeUnit) {
        if (this.scheduler == null) {
            throw new IllegalStateException("No TestScheduler provided. Perhaps you forgot to 'assertThat(Observable, TestScheduler)'?");
        }
        this.scheduler.advanceTimeBy(duration, timeUnit);
        return this;
    }
}

