/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.utils.DBusNamingUtil;

public class DBusMatchRule {
    private static final Pattern IFACE_PATTERN = Pattern.compile(".*\\..*");
    private static final Map<String, Class<? extends DBusSignal>> SIGNALTYPEMAP = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private String type;
    private String iface;
    private String member;
    private String object;
    private String source;

    public static Class<? extends DBusSignal> getCachedSignalType(String _type) {
        return SIGNALTYPEMAP.get(_type);
    }

    public DBusMatchRule(String _type, String _iface, String _member) {
        this.type = _type;
        this.iface = _iface;
        this.member = _member;
    }

    public DBusMatchRule(String _type, String _iface, String _member, String _object) {
        this.type = _type;
        this.iface = _iface;
        this.member = _member;
        this.object = _object;
    }

    public DBusMatchRule(DBusExecutionException _e) throws DBusException {
        this(_e.getClass());
        this.member = null;
        this.type = "error";
    }

    public DBusMatchRule(Message _m) {
        this.iface = _m.getInterface();
        this.member = _m.getName();
        if (_m instanceof DBusSignal) {
            this.type = "signal";
        } else if (_m instanceof Error) {
            this.type = "error";
            this.member = null;
        } else if (_m instanceof MethodCall) {
            this.type = "method_call";
        } else if (_m instanceof MethodReturn) {
            this.type = "method_reply";
        }
    }

    public DBusMatchRule(Class<? extends DBusInterface> _c, String _method) throws DBusException {
        this(_c);
        this.member = _method;
        this.type = "method_call";
    }

    public DBusMatchRule(Class<? extends Object> _c, String _source, String _object) throws DBusException {
        this(_c);
        this.source = _source;
        this.object = _object;
    }

    public DBusMatchRule(Class<? extends Object> _c) throws DBusException {
        if (DBusInterface.class.isAssignableFrom(_c)) {
            this.iface = DBusNamingUtil.getInterfaceName(_c);
            this.assertDBusInterface(this.iface);
            this.member = null;
            this.type = null;
        } else if (DBusSignal.class.isAssignableFrom(_c)) {
            if (null == _c.getEnclosingClass()) {
                throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
            }
            this.iface = DBusNamingUtil.getInterfaceName(_c.getEnclosingClass());
            this.assertDBusInterface(this.iface);
            this.member = DBusNamingUtil.getSignalName(_c);
            SIGNALTYPEMAP.put(this.iface + "$" + this.member, _c);
            this.type = "signal";
        } else if (Error.class.isAssignableFrom(_c)) {
            this.iface = DBusNamingUtil.getInterfaceName(_c);
            this.assertDBusInterface(this.iface);
            this.member = null;
            this.type = "error";
        } else if (DBusExecutionException.class.isAssignableFrom(_c)) {
            this.iface = DBusNamingUtil.getInterfaceName(_c);
            this.assertDBusInterface(this.iface);
            this.member = null;
            this.type = "error";
        } else {
            throw new DBusException("Invalid type for match rule: " + _c);
        }
    }

    void assertDBusInterface(String _str) throws DBusException {
        if (!IFACE_PATTERN.matcher(_str).matches()) {
            throw new DBusException("DBusInterfaces must be defined in a package.");
        }
    }

    public String toString() {
        String s = null;
        if (null != this.type) {
            String string = s = null == s ? "type='" + this.type + "'" : s + ",type='" + this.type + "'";
        }
        if (null != this.member) {
            String string = s = null == s ? "member='" + this.member + "'" : s + ",member='" + this.member + "'";
        }
        if (null != this.iface) {
            String string = s = null == s ? "interface='" + this.iface + "'" : s + ",interface='" + this.iface + "'";
        }
        if (null != this.source) {
            String string = s = null == s ? "sender='" + this.source + "'" : s + ",sender='" + this.source + "'";
        }
        if (null != this.object) {
            s = null == s ? "path='" + this.object + "'" : s + ",path='" + this.object + "'";
        }
        return s;
    }

    public String getType() {
        return this.type;
    }

    public String getInterface() {
        return this.iface;
    }

    public String getMember() {
        return this.member;
    }

    public String getSource() {
        return this.source;
    }

    public String getObject() {
        return this.object;
    }
}

