/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.FatalException;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingMessageThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean terminate;
    private final AbstractConnection connection;

    public IncomingMessageThread(AbstractConnection _connection, BusAddress _busAddress) {
        Objects.requireNonNull(_connection);
        this.connection = _connection;
        this.setName("DBusConnection [listener=" + _busAddress.isListeningSocket() + "]");
        this.setDaemon(true);
    }

    public void terminate() {
        this.terminate = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.terminate) {
            Message msg = null;
            try {
                msg = this.connection.readIncoming();
                if (msg == null) continue;
                this.logger.trace("Got Incoming Message: {}", (Object)msg);
                this.connection.handleMessage(msg);
            }
            catch (RejectedExecutionException | DBusException _ex) {
                if (_ex instanceof FatalException) {
                    if (this.terminate) {
                        return;
                    }
                    this.logger.error("FatalException in connection thread", (Throwable)_ex);
                    if (this.connection.isConnected()) {
                        this.terminate = true;
                        if (_ex.getCause() instanceof IOException) {
                            this.connection.internalDisconnect((IOException)_ex.getCause());
                        } else {
                            this.connection.internalDisconnect(null);
                        }
                    }
                    return;
                }
                if (this.terminate) continue;
                this.logger.error("Exception in connection thread", (Throwable)_ex);
            }
        }
    }
}

