/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.freedesktop.dbus.utils.NameableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingService {
    private static final ReceivingServiceConfig DEFAULT_CFG = new ReceivingServiceConfig(1, 1, 4, 1);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean closed = false;
    private final Map<ExecutorNames, ExecutorService> executors = new EnumMap<ExecutorNames, ExecutorService>(ExecutorNames.class);

    public ReceivingService(ReceivingServiceConfig _rsCfg) {
        ReceivingServiceConfig rsCfg = Optional.ofNullable(_rsCfg).orElse(DEFAULT_CFG);
        this.executors.put(ExecutorNames.SIGNAL, Executors.newFixedThreadPool(rsCfg.getSignalThreadPoolSize(), new NameableThreadFactory("DBus-Signal-Receiver-", true)));
        this.executors.put(ExecutorNames.ERROR, Executors.newFixedThreadPool(rsCfg.getErrorThreadPoolSize(), new NameableThreadFactory("DBus-Error-Receiver-", true)));
        this.executors.put(ExecutorNames.METHODCALL, Executors.newFixedThreadPool(rsCfg.getMethodCallThreadPoolSize(), new NameableThreadFactory("DBus-MethodCall-Receiver-", true)));
        this.executors.put(ExecutorNames.METHODRETURN, Executors.newFixedThreadPool(rsCfg.getMethodReturnThreadPoolSize(), new NameableThreadFactory("DBus-MethodReturn-Receiver-", true)));
    }

    void execSignalHandler(Runnable _r) {
        this.execOrFail(ExecutorNames.SIGNAL, _r);
    }

    void execErrorHandler(Runnable _r) {
        this.execOrFail(ExecutorNames.ERROR, _r);
    }

    void execMethodCallHandler(Runnable _r) {
        this.execOrFail(ExecutorNames.METHODCALL, _r);
    }

    void execMethodReturnHandler(Runnable _r) {
        this.execOrFail(ExecutorNames.METHODRETURN, _r);
    }

    void execOrFail(ExecutorNames _executor, Runnable _r) {
        if (_r == null || _executor == null) {
            return;
        }
        ExecutorService exec = this.executors.get((Object)_executor);
        if (this.closed || exec.isShutdown() || exec.isTerminated()) {
            throw new IllegalStateException("Receiving service already closed");
        }
        exec.execute(_r);
    }

    public synchronized void shutdown(int _timeout, TimeUnit _unit) {
        for (Map.Entry<ExecutorNames, ExecutorService> es : this.executors.entrySet()) {
            this.logger.debug("Shutting down executor: {}", (Object)es.getKey());
            es.getValue().shutdown();
        }
        for (Map.Entry<ExecutorNames, ExecutorService> es : this.executors.entrySet()) {
            try {
                es.getValue().awaitTermination(_timeout, _unit);
            }
            catch (InterruptedException _ex) {
                LoggerFactory.getLogger(this.getClass()).debug("Interrupted while waiting for termination of executor", (Throwable)_ex);
            }
        }
        this.closed = true;
    }

    public synchronized void shutdownNow() {
        for (Map.Entry<ExecutorNames, ExecutorService> es : this.executors.entrySet()) {
            if (es.getValue().isTerminated()) continue;
            this.logger.debug("Forcefully stopping {}", (Object)es.getKey());
            es.getValue().shutdownNow();
        }
    }

    static enum ExecutorNames {
        SIGNAL("SignalExecutor"),
        ERROR("ErrorExecutor"),
        METHODCALL("MethodCallExecutor"),
        METHODRETURN("MethodReturnExecutor");

        private final String description;

        private ExecutorNames(String _name) {
            this.description = _name;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static final class ReceivingServiceConfig {
        private final int signalThreadPoolSize;
        private final int errorThreadPoolSize;
        private final int methodCallThreadPoolSize;
        private final int methodReturnThreadPoolSize;

        public ReceivingServiceConfig(int _signalThreadPoolSize, int _errorThreadPoolSize, int _methodCallThreadPoolSize, int _methodReturnThreadPoolSize) {
            this.signalThreadPoolSize = _signalThreadPoolSize;
            this.errorThreadPoolSize = _errorThreadPoolSize;
            this.methodCallThreadPoolSize = _methodCallThreadPoolSize;
            this.methodReturnThreadPoolSize = _methodReturnThreadPoolSize;
        }

        public int getSignalThreadPoolSize() {
            return this.signalThreadPoolSize;
        }

        public int getErrorThreadPoolSize() {
            return this.errorThreadPoolSize;
        }

        public int getMethodCallThreadPoolSize() {
            return this.methodCallThreadPoolSize;
        }

        public int getMethodReturnThreadPoolSize() {
            return this.methodReturnThreadPoolSize;
        }
    }
}

