/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentMap;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.ReceivingService;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.utils.AddressBuilder;

public class DBusConnectionBuilder {
    private final String address;
    private final String machineId;
    private boolean registerSelf = true;
    private boolean shared = true;
    private boolean weakReference = false;
    private byte endianess = DBusConnectionBuilder.getSystemEndianness();
    private int timeout = 100000;
    private int signalThreadCount = 1;
    private int errorThreadCount = 1;
    private int methodCallThreadCount = 4;
    private int methodReturnThreadCount = 1;
    private IDisconnectCallback disconnectCallback;

    private DBusConnectionBuilder(String _address, String _machineId) {
        this.address = _address;
        this.machineId = _machineId;
    }

    public static DBusConnectionBuilder forSessionBus(String _machineIdFileLocation) {
        String address = AddressBuilder.getSessionConnection(_machineIdFileLocation);
        if ((address = DBusConnectionBuilder.tcpFallback(address)) == null) {
            throw new IllegalArgumentException("No valid connection address found for any transport");
        }
        DBusConnectionBuilder instance = new DBusConnectionBuilder(address, AddressBuilder.getDbusMachineId(_machineIdFileLocation));
        return instance;
    }

    public static DBusConnectionBuilder forSystemBus() {
        String address = AddressBuilder.getSystemConnection();
        address = DBusConnectionBuilder.tcpFallback(address);
        return new DBusConnectionBuilder(address, AddressBuilder.getDbusMachineId(null));
    }

    public static DBusConnectionBuilder forSessionBus() {
        return DBusConnectionBuilder.forSessionBus(null);
    }

    public static DBusConnectionBuilder forType(DBusConnection.DBusBusType _type) {
        return DBusConnectionBuilder.forType(_type, null);
    }

    public static DBusConnectionBuilder forType(DBusConnection.DBusBusType _type, String _machineIdFile) {
        if (_type == DBusConnection.DBusBusType.SESSION) {
            return DBusConnectionBuilder.forSessionBus(_machineIdFile);
        }
        if (_type == DBusConnection.DBusBusType.SYSTEM) {
            return DBusConnectionBuilder.forSystemBus();
        }
        throw new IllegalArgumentException("Unknown bus type: " + _type);
    }

    public static DBusConnectionBuilder forAddress(String _address) {
        DBusConnectionBuilder instance = new DBusConnectionBuilder(_address, AddressBuilder.getDbusMachineId(null));
        return instance;
    }

    public DBusConnectionBuilder withRegisterSelf(boolean _register) {
        this.registerSelf = _register;
        return this;
    }

    public DBusConnectionBuilder withShared(boolean _shared) {
        this.shared = _shared;
        return this;
    }

    public DBusConnectionBuilder withTimeout(int _timeout) {
        this.timeout = _timeout;
        return this;
    }

    public DBusConnectionBuilder withSignalThreadCount(int _threads) {
        this.signalThreadCount = Math.max(1, _threads);
        return this;
    }

    public DBusConnectionBuilder withErrorHandlerThreadCount(int _threads) {
        this.errorThreadCount = Math.max(1, _threads);
        return this;
    }

    public DBusConnectionBuilder withMethodCallThreadCount(int _threads) {
        this.methodCallThreadCount = Math.max(1, _threads);
        return this;
    }

    public DBusConnectionBuilder withMethodReturnThreadCount(int _threads) {
        this.methodReturnThreadCount = Math.max(1, _threads);
        return this;
    }

    public DBusConnectionBuilder withEndianess(byte _endianess) {
        if (_endianess == 66 || _endianess == 108) {
            this.endianess = _endianess;
        }
        return this;
    }

    public DBusConnectionBuilder withDisconnectCallback(IDisconnectCallback _disconnectCallback) {
        this.disconnectCallback = _disconnectCallback;
        return this;
    }

    public DBusConnectionBuilder withWeakReferences(boolean _weakRef) {
        this.weakReference = _weakRef;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusConnection build() throws DBusException {
        DBusConnection c;
        ReceivingService.ReceivingServiceConfig cfg = new ReceivingService.ReceivingServiceConfig(this.signalThreadCount, this.errorThreadCount, this.methodCallThreadCount, this.methodReturnThreadCount);
        if (this.shared) {
            ConcurrentMap<String, DBusConnection> concurrentMap = DBusConnection.CONNECTIONS;
            synchronized (concurrentMap) {
                c = (DBusConnection)DBusConnection.CONNECTIONS.get(this.address);
                if (c != null) {
                    c.concurrentConnections.incrementAndGet();
                    return c;
                }
                c = new DBusConnection(this.address, this.shared, this.machineId, this.timeout, cfg);
                DBusConnection.CONNECTIONS.put(this.address, c);
            }
        } else {
            c = new DBusConnection(this.address, this.shared, this.machineId, this.timeout, cfg);
        }
        c.setDisconnectCallback(this.disconnectCallback);
        c.setWeakReferences(this.weakReference);
        DBusConnection.setEndianness(this.endianess);
        c.connect(this.registerSelf);
        return c;
    }

    private static String tcpFallback(String _address) {
        if (!TransportBuilder.getRegisteredBusTypes().contains("UNIX") && TransportBuilder.getRegisteredBusTypes().contains("TCP") && (_address == null || _address.startsWith("unix")) && ((_address = System.getProperty("DBUS_TCP_SESSION")) == null || _address.isBlank())) {
            throw new IllegalArgumentException("No valid TCP connection address found, please specify 'DBUS_TCP_SESSION' system property");
        }
        return _address;
    }

    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }
}

