/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.ReceivingService;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.utils.CommonRegexPattern;
import org.freedesktop.dbus.utils.Hexdump;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectConnection
extends AbstractConnection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String machineId = this.createMachineId();

    @Deprecated(since="4.1.0", forRemoval=true)
    public DirectConnection(String _address) throws DBusException {
        this(_address, 100000);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public DirectConnection(String _address, int _timeout) throws DBusException {
        this(_timeout, _address, null);
    }

    DirectConnection(int _timeout, String _address, ReceivingService.ReceivingServiceConfig _rsCfg) throws DBusException {
        super(_address, _timeout, _rsCfg);
        if (!this.getAddress().isServer()) {
            super.listen();
        }
    }

    @Override
    public void listen() {
        if (this.getAddress().isServer()) {
            super.listen();
        }
    }

    private String createMachineId() {
        try {
            String ascii = Hexdump.toAscii(MessageDigest.getInstance("MD5").digest(InetAddress.getLocalHost().getHostName().getBytes()));
            return ascii;
        }
        catch (UnknownHostException | NoSuchAlgorithmException exception) {
            return Util.randomString(32);
        }
    }

    <T> T dynamicProxy(String _path, Class<T> _type) throws DBusException {
        try {
            Introspectable intro = this.getRemoteObject(_path, Introspectable.class);
            String data = intro.Introspect();
            String[] tags = CommonRegexPattern.PROXY_SPLIT_PATTERN.split(data);
            List ifaces = Arrays.stream(tags).filter(t -> t.startsWith("interface")).map(t -> CommonRegexPattern.IFACE_PATTERN.matcher((CharSequence)t).replaceAll("$1")).collect(Collectors.toList());
            ArrayList<Class<T>> ifcs = new ArrayList<Class<T>>();
            if (_type == null) {
                block4: for (String iface : ifaces) {
                    int j = 0;
                    while (j >= 0) {
                        try {
                            ifcs.add(Class.forName(iface));
                            continue block4;
                        }
                        catch (Exception exception) {
                            j = iface.lastIndexOf(46);
                            char[] cs = iface.toCharArray();
                            if (j < 0) continue;
                            cs[j] = 36;
                            iface = String.valueOf(cs);
                        }
                    }
                }
            } else {
                ifcs.add(_type);
            }
            if (ifcs.isEmpty()) {
                throw new DBusException("Could not find an interface to cast to");
            }
            RemoteObject ro = new RemoteObject(null, _path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.getImportedObjects().put(newi, ro);
            return (T)newi;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusException(String.format("Failed to create proxy object for %s; reason: %s.", _path, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends DBusInterface> T getExportedObject(String _path, Class<T> _type) throws DBusException {
        ExportedObject o = null;
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            o = this.getExportedObjects().get(_path);
        }
        if (null != o && null == o.getObject().get()) {
            this.unExportObject(_path);
            o = null;
        }
        if (null != o) {
            return (T)o.getObject().get();
        }
        return (T)((DBusInterface)this.dynamicProxy(_path, _type));
    }

    public DBusInterface getRemoteObject(String _objectPath) throws DBusException {
        if (null == _objectPath) {
            throw new DBusException("Invalid object path: null");
        }
        if (_objectPath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectPath).matches()) {
            throw new DBusException("Invalid object path: " + _objectPath);
        }
        return (DBusInterface)this.dynamicProxy(_objectPath, null);
    }

    public <T extends DBusInterface> T getRemoteObject(String _objectPath, Class<T> _type) throws DBusException {
        if (null == _objectPath) {
            throw new DBusException("Invalid object path: null");
        }
        if (null == _type) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (_objectPath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectPath).matches()) {
            throw new DBusException("Invalid object path: " + _objectPath);
        }
        if (!DBusInterface.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (_type.getName().equals(_type.getSimpleName())) {
            throw new DBusException("DBusInterfaces cannot be declared outside a package");
        }
        RemoteObject ro = new RemoteObject(null, _objectPath, _type, false);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(_type.getClassLoader(), new Class[]{_type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.getImportedObjects().put(i, ro);
        return (T)i;
    }

    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule _rule, DBusSigHandler<T> _handler) throws DBusException {
        SignalTuple key = new SignalTuple(_rule.getInterface(), _rule.getMember(), _rule.getObject(), _rule.getSource());
        Queue<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(key);
        if (null != v) {
            v.remove(_handler);
            if (0 == v.size()) {
                this.getHandledSignals().remove(key);
            }
        }
    }

    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule _rule, DBusSigHandler<T> _handler) throws DBusException {
        SignalTuple key = new SignalTuple(_rule.getInterface(), _rule.getMember(), _rule.getObject(), _rule.getSource());
        Queue v = this.getHandledSignals().computeIfAbsent(key, val -> {
            ConcurrentLinkedQueue l = new ConcurrentLinkedQueue();
            return l;
        });
        v.add(_handler);
    }

    @Override
    protected void removeGenericSigHandler(DBusMatchRule _rule, DBusSigHandler<DBusSignal> _handler) throws DBusException {
        SignalTuple key = new SignalTuple(_rule.getInterface(), _rule.getMember(), _rule.getObject(), _rule.getSource());
        Queue<DBusSigHandler<DBusSignal>> v = this.getGenericHandledSignals().get(key);
        if (null != v) {
            v.remove(_handler);
            if (0 == v.size()) {
                this.getGenericHandledSignals().remove(key);
            }
        }
    }

    @Override
    protected void addGenericSigHandler(DBusMatchRule _rule, DBusSigHandler<DBusSignal> _handler) throws DBusException {
        SignalTuple key = new SignalTuple(_rule.getInterface(), _rule.getMember(), _rule.getObject(), _rule.getSource());
        Queue v = this.getGenericHandledSignals().computeIfAbsent(key, val -> {
            ConcurrentLinkedQueue l = new ConcurrentLinkedQueue();
            return l;
        });
        v.add(_handler);
    }

    @Override
    public <T extends DBusInterface> T getExportedObject(String _source, String _path, Class<T> _type) throws DBusException {
        return this.getExportedObject(_path, _type);
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }

    @Override
    public DBusInterface getExportedObject(String _source, String _path) throws DBusException {
        return this.getExportedObject(_path, (Class)null);
    }
}

