/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.nio.ByteOrder;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.ReceivingService;
import org.freedesktop.dbus.connections.impl.DirectConnection;
import org.freedesktop.dbus.exceptions.DBusException;

public class DirectConnectionBuilder {
    private final String address;
    private boolean weakReference = false;
    private byte endianess = DirectConnectionBuilder.getSystemEndianness();
    private int timeout = 100000;
    private int signalThreadCount = 1;
    private int errorThreadCount = 1;
    private int methodCallThreadCount = 4;
    private int methodReturnThreadCount = 1;
    private IDisconnectCallback disconnectCallback;

    private DirectConnectionBuilder(String _address) {
        this.address = _address;
    }

    public static DirectConnectionBuilder forAddress(String _address) {
        DirectConnectionBuilder instance = new DirectConnectionBuilder(_address);
        return instance;
    }

    public DirectConnectionBuilder withTimeout(int _timeout) {
        this.timeout = _timeout;
        return this;
    }

    public DirectConnectionBuilder withSignalThreadCount(int _threads) {
        this.signalThreadCount = Math.max(1, _threads);
        return this;
    }

    public DirectConnectionBuilder withErrorHandlerThreadCount(int _threads) {
        this.errorThreadCount = Math.max(1, _threads);
        return this;
    }

    public DirectConnectionBuilder withMethodCallThreadCount(int _threads) {
        this.methodCallThreadCount = Math.max(1, _threads);
        return this;
    }

    public DirectConnectionBuilder withMethodReturnThreadCount(int _threads) {
        this.methodReturnThreadCount = Math.max(1, _threads);
        return this;
    }

    public DirectConnectionBuilder withEndianess(byte _endianess) {
        if (_endianess == 66 || _endianess == 108) {
            this.endianess = _endianess;
        }
        return this;
    }

    public DirectConnectionBuilder withDisconnectCallback(IDisconnectCallback _disconnectCallback) {
        this.disconnectCallback = _disconnectCallback;
        return this;
    }

    public DirectConnectionBuilder withWeakReferences(boolean _weakRef) {
        this.weakReference = _weakRef;
        return this;
    }

    public DirectConnection build() throws DBusException {
        ReceivingService.ReceivingServiceConfig cfg = new ReceivingService.ReceivingServiceConfig(this.signalThreadCount, this.errorThreadCount, this.methodCallThreadCount, this.methodReturnThreadCount);
        DirectConnection c = new DirectConnection(this.timeout, this.address, cfg);
        c.setDisconnectCallback(this.disconnectCallback);
        c.setWeakReferences(this.weakReference);
        DirectConnection.setEndianness(this.endianess);
        return c;
    }

    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }
}

