/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.freedesktop.dbus.exceptions.TransportRegistrationException;
import org.freedesktop.dbus.spi.transport.ITransportProvider;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportBuilder.class);
    private static final Map<String, ITransportProvider> PROVIDERS = TransportBuilder.getTransportProvider();
    private String address;
    private BusAddress busAddress;
    private boolean listening;
    private int timeout = 100000;
    private boolean autoConnect = true;
    private SaslAuthMode authMode = null;
    private String fileOwner;
    private String fileGroup;
    private Set<PosixFilePermission> fileUnixPermissions;

    static Map<String, ITransportProvider> getTransportProvider() {
        ConcurrentHashMap<String, ITransportProvider> providers = new ConcurrentHashMap<String, ITransportProvider>();
        try {
            ServiceLoader<ITransportProvider> spiLoader = ServiceLoader.load(ITransportProvider.class);
            for (ITransportProvider provider : spiLoader) {
                String providerBusType = provider.getSupportedBusType();
                if (providerBusType == null) {
                    LOGGER.warn("Transport {} is invalid: No bustype configured", provider.getClass());
                    continue;
                }
                providerBusType = providerBusType.toUpperCase();
                LOGGER.debug("Found provider '{}' named '{}' providing bustype '{}'", new Object[]{provider.getClass().getSimpleName(), provider.getTransportName(), providerBusType});
                if (providers.containsKey(providerBusType)) {
                    throw new TransportRegistrationException("Found transport " + ((ITransportProvider)providers.get(providerBusType)).getClass().getName() + " and " + provider.getClass().getName() + " both providing transport for socket type " + providerBusType + ", please only add one of them to classpath.");
                }
                providers.put(providerBusType, provider);
            }
            if (providers.isEmpty()) {
                throw new TransportRegistrationException("No dbus-java-transport found in classpath, please add a transport module");
            }
        }
        catch (ServiceConfigurationError _ex) {
            LOGGER.error("Could not initialize service provider.", (Throwable)_ex);
        }
        return providers;
    }

    private TransportBuilder(String _address) throws DBusException {
        if (_address == null || _address.isBlank()) {
            throw new IllegalArgumentException("BusAddress cannot be empty or null");
        }
        this.address = _address;
        this.listening = _address.contains(",listen=true");
        this.updateAddress();
    }

    private TransportBuilder(BusAddress _address) throws DBusException {
        Objects.requireNonNull(_address, "Address required");
        this.address = _address.getRawAddress();
        this.listening = _address.isListeningSocket();
        this.busAddress = _address;
    }

    public static TransportBuilder create(String _address) throws DBusException {
        return new TransportBuilder(_address);
    }

    public static TransportBuilder create(BusAddress _address) throws DBusException {
        return new TransportBuilder(_address);
    }

    public static TransportBuilder createWithDynamicSession(String _transportType) throws DBusException {
        String dynSession = TransportBuilder.createDynamicSession(_transportType, false);
        if (dynSession == null) {
            throw new DBusException("Could not create dynamic session for transport type '" + _transportType + "'");
        }
        return new TransportBuilder(dynSession);
    }

    public TransportBuilder withTimeout(int _timeout) {
        this.timeout = _timeout < 0 ? 100000 : _timeout;
        return this;
    }

    public TransportBuilder isListening(boolean _listen) {
        this.listening = _listen;
        return this;
    }

    public TransportBuilder withAutoConnect(boolean _connect) {
        this.autoConnect = _connect;
        return this;
    }

    public TransportBuilder withSaslAuthMode(SaslAuthMode _authMode) {
        this.authMode = _authMode;
        return this;
    }

    public TransportBuilder withUnixSocketFileOwner(String _user) {
        this.fileOwner = _user;
        return this;
    }

    public TransportBuilder withUnixSocketFileGroup(String _group) {
        this.fileGroup = _group;
        return this;
    }

    public TransportBuilder withUnixSocketFilePermissions(PosixFilePermission ... _permissions) {
        if (Util.isWindows()) {
            return this;
        }
        if (_permissions == null || _permissions.length < 1) {
            return this;
        }
        this.fileUnixPermissions = new LinkedHashSet<PosixFilePermission>(Arrays.asList(_permissions));
        return this;
    }

    private void setFilePermissions(Path _path) {
        Objects.requireNonNull(_path, "Path required");
        UserPrincipalLookupService userPrincipalLookupService = _path.getFileSystem().getUserPrincipalLookupService();
        if (userPrincipalLookupService == null) {
            LOGGER.error("Unable to set user/group permissions on {}", (Object)_path);
        }
        if (!Util.isBlank(this.fileOwner)) {
            try {
                UserPrincipal userPrincipal = userPrincipalLookupService.lookupPrincipalByName(this.fileOwner);
                if (userPrincipal != null) {
                    Files.getFileAttributeView(_path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setOwner(userPrincipal);
                }
            }
            catch (IOException _ex) {
                LOGGER.error("Could not change owner of {} to {}", new Object[]{_path, this.fileOwner, _ex});
            }
        }
        if (!Util.isBlank(this.fileGroup)) {
            try {
                GroupPrincipal groupPrincipal = userPrincipalLookupService.lookupPrincipalByGroupName(this.fileGroup);
                if (groupPrincipal != null) {
                    Files.getFileAttributeView(_path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(groupPrincipal);
                }
            }
            catch (IOException _ex) {
                LOGGER.error("Could not change group of {} to {}", new Object[]{_path, this.fileGroup, _ex});
            }
        }
        if (!Util.isWindows() && this.fileUnixPermissions != null) {
            try {
                Files.setPosixFilePermissions(_path, this.fileUnixPermissions);
            }
            catch (Exception _ex) {
                LOGGER.error("Could not set file permissions of {} to {}", new Object[]{_path, this.fileUnixPermissions, _ex});
            }
        }
    }

    public AbstractTransport build() throws DBusException, IOException {
        this.updateAddress();
        BusAddress myBusAddress = this.getAddress();
        AbstractTransport transport = null;
        ITransportProvider provider = PROVIDERS.get(myBusAddress.getBusType());
        if (provider == null) {
            throw new DBusException("No transport provider found for bustype " + myBusAddress.getBusType());
        }
        try {
            transport = provider.createTransport(myBusAddress, this.timeout);
            if (this.authMode != null) {
                transport.setSaslAuthMode(this.authMode.getAuthMode());
            }
        }
        catch (TransportConfigurationException _ex) {
            LOGGER.error("Could not initialize transport", (Throwable)_ex);
        }
        if (transport == null) {
            throw new DBusException("Unknown address type " + myBusAddress.getType() + " or no transport provider found for bus type " + myBusAddress.getBusType());
        }
        if (myBusAddress.isListeningSocket() && myBusAddress.isFileBasedAddress()) {
            this.setFilePermissions(new File(myBusAddress.getPath()).toPath());
        }
        if (this.autoConnect) {
            transport.connect();
        }
        return transport;
    }

    public BusAddress getAddress() {
        return this.busAddress;
    }

    private void updateAddress() throws DBusException {
        this.busAddress = new BusAddress(this.address);
        if (!this.busAddress.isListeningSocket() && this.listening) {
            this.address = this.address + ",listen=true";
            this.busAddress = new BusAddress(this.address);
        } else if (this.busAddress.isListeningSocket() && !this.listening) {
            this.address = this.address.replace(",listen=true", "");
            this.busAddress = new BusAddress(this.address);
        }
    }

    public static List<String> getRegisteredBusTypes() {
        return new ArrayList<String>(PROVIDERS.keySet());
    }

    public static String createDynamicSession(String _busType, boolean _listeningAddress) {
        Objects.requireNonNull(_busType, "Bustype required");
        ITransportProvider provider = PROVIDERS.get(_busType.toUpperCase());
        if (provider != null) {
            return provider.createDynamicSessionAddress(_listeningAddress);
        }
        return null;
    }

    public static enum SaslAuthMode {
        AUTH_ANONYMOUS(4),
        AUTH_COOKIE(2),
        AUTH_EXTERNAL(1);

        private final int authMode;

        private SaslAuthMode(int _authMode) {
            this.authMode = _authMode;
        }

        public int getAuthMode() {
            return this.authMode;
        }
    }
}

