/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.errors.AccessDenied;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.errors.MatchRuleInvalid;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.FatalException;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.spi.message.InputStreamMessageReader;
import org.freedesktop.dbus.spi.message.OutputStreamMessageWriter;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBusDaemon
extends Thread
implements Closeable {
    public static final int QUEUE_POLL_WAIT = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBusDaemon.class);
    private final Map<ConnectionStruct, DBusDaemonReaderThread> conns = new ConcurrentHashMap<ConnectionStruct, DBusDaemonReaderThread>();
    private final Map<String, ConnectionStruct> names = Collections.synchronizedMap(new HashMap());
    private final MagicMap<Message, WeakReference<ConnectionStruct>> outqueue = new MagicMap("out");
    private final MagicMap<Message, WeakReference<ConnectionStruct>> inqueue = new MagicMap("in");
    private final MagicMap<Message, WeakReference<ConnectionStruct>> localqueue = new MagicMap("local");
    private final List<ConnectionStruct> sigrecips = new ArrayList<ConnectionStruct>();
    private final Object uniqueLock = new Object();
    private final DBusServer dbusServer = new DBusServer();
    private final DBusDaemonSenderThread sender = new DBusDaemonSenderThread();
    private final AtomicBoolean run = new AtomicBoolean(false);
    private int nextUnique = 0;

    public DBusDaemon() {
        this.setName(this.getClass().getSimpleName() + "-Thread");
        this.names.put("org.freedesktop.DBus", null);
    }

    private void send(ConnectionStruct _connStruct, Message _msg) {
        this.send(_connStruct, _msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(ConnectionStruct _connStruct, Message _msg, boolean _head) {
        if (null == _connStruct) {
            LOGGER.trace("Queuing message {} for all connections", (Object)_msg);
            Map<ConnectionStruct, DBusDaemonReaderThread> map = this.conns;
            synchronized (map) {
                MagicMap<Message, WeakReference<ConnectionStruct>> magicMap = this.outqueue;
                synchronized (magicMap) {
                    for (ConnectionStruct d : this.conns.keySet()) {
                        if (_head) {
                            this.outqueue.putFirst(_msg, new WeakReference<ConnectionStruct>(d));
                            continue;
                        }
                        this.outqueue.putLast(_msg, new WeakReference<ConnectionStruct>(d));
                    }
                    this.outqueue.notifyAll();
                }
            }
        }
        LOGGER.trace("Queuing message {} for {}", (Object)_msg, (Object)_connStruct.unique);
        MagicMap<Message, WeakReference<ConnectionStruct>> magicMap = this.outqueue;
        synchronized (magicMap) {
            if (_head) {
                this.outqueue.putFirst(_msg, new WeakReference<ConnectionStruct>(_connStruct));
            } else {
                this.outqueue.putLast(_msg, new WeakReference<ConnectionStruct>(_connStruct));
            }
            this.outqueue.notifyAll();
        }
    }

    @Override
    public synchronized void start() {
        super.start();
        this.dbusServer.start();
        this.sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.run.set(true);
        while (this.isRunning()) {
            try {
                List<WeakReference<ConnectionStruct>> wcs;
                Message m;
                MagicMap<Message, WeakReference<ConnectionStruct>> magicMap = this.inqueue;
                synchronized (magicMap) {
                    while (0 == this.inqueue.size()) {
                        try {
                            this.inqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    m = this.inqueue.head();
                    wcs = this.inqueue.remove(m);
                }
                if (null == wcs) continue;
                for (WeakReference weakReference : wcs) {
                    ConnectionStruct c = (ConnectionStruct)weakReference.get();
                    if (null == c) continue;
                    this.logMessage("<inqueue> Got message {} from {}", m, c.unique);
                    if (!(null != c.unique || m instanceof MethodCall && "org.freedesktop.DBus".equals(m.getDestination()) && "Hello".equals(m.getName()))) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.AccessDenied", m.getSerial(), "s", "You must send a Hello message"));
                        continue;
                    }
                    try {
                        if (null != c.unique) {
                            m.setSource(c.unique);
                        }
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.GeneralError", m.getSerial(), "s", "Sending message failed"));
                    }
                    if ("org.freedesktop.DBus".equals(m.getDestination())) {
                        MagicMap<Message, WeakReference<ConnectionStruct>> dbe = this.localqueue;
                        synchronized (dbe) {
                            this.localqueue.putLast(m, weakReference);
                            this.localqueue.notifyAll();
                            continue;
                        }
                    }
                    if (m instanceof DBusSignal) {
                        ArrayList<ConnectionStruct> l;
                        List<ConnectionStruct> list = this.sigrecips;
                        synchronized (list) {
                            l = new ArrayList<ConnectionStruct>(this.sigrecips);
                        }
                        ArrayList<ConnectionStruct> list2 = l;
                        for (ConnectionStruct d : list2) {
                            this.send(d, m);
                        }
                        continue;
                    }
                    ConnectionStruct dest = this.names.get(m.getDestination());
                    if (null == dest) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.ServiceUnknown", m.getSerial(), "s", String.format("The name `%s' does not exist", m.getDestination())));
                        continue;
                    }
                    this.send(dest, m);
                }
            }
            catch (DBusException dbe) {
                LOGGER.debug("", (Throwable)dbe);
            }
        }
    }

    private void logMessage(String _logStr, Message _m, String _connUniqueId) {
        Object logMsg = _m;
        if (_m != null && Introspectable.class.getName().equals(_m.getInterface()) && !LOGGER.isTraceEnabled()) {
            logMsg = "<Introspection data only visible in loglevel trace>";
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(_logStr, logMsg, (Object)_connUniqueId);
        } else {
            LOGGER.debug(_logStr, (Object)_m, (Object)_connUniqueId);
        }
    }

    public synchronized boolean isRunning() {
        return this.run.get() && this.isAlive();
    }

    @Override
    public void close() {
        this.run.set(false);
        this.sender.terminate();
        this.dbusServer.terminate();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(ConnectionStruct _c) {
        boolean exists = false;
        Map<Object, Object> map = this.conns;
        synchronized (map) {
            if (this.conns.containsKey(_c)) {
                DBusDaemonReaderThread r = this.conns.get(_c);
                exists = true;
                r.stopRunning();
                this.conns.remove(_c);
            }
        }
        if (exists) {
            try {
                if (null != _c.socketChannel) {
                    _c.socketChannel.close();
                }
            }
            catch (IOException _exIo) {
                LOGGER.trace("Error while closing socketchannel", (Throwable)_exIo);
            }
            map = this.names;
            synchronized (map) {
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String name : this.names.keySet()) {
                    if (this.names.get(name) != _c) continue;
                    toRemove.add(name);
                    try {
                        this.send(null, new DBus.NameOwnerChanged("/org/freedesktop/DBus", name, _c.unique, ""));
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                    }
                }
                for (String name : toRemove) {
                    this.names.remove(name);
                }
            }
        }
    }

    void addSock(SocketChannel _sock) throws IOException {
        LOGGER.debug("New Client");
        ConnectionStruct c = new ConnectionStruct(_sock);
        DBusDaemonReaderThread r = new DBusDaemonReaderThread(c);
        this.conns.put(c, r);
        r.start();
    }

    public static void syntax() {
        System.out.println("Syntax: DBusDaemon [--version] [-v] [--help] [-h] [--listen address] [-l address] [--print-address] [-r] [--pidfile file] [-p file] [--addressfile file] [-a file] [--unix] [-u] [--tcp] [-t] ");
        System.exit(1);
    }

    public static void version() {
        System.out.println("D-Bus Java Version: " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void saveFile(String _data, String _file) throws IOException {
        try (PrintWriter w = new PrintWriter(new FileOutputStream(_file));){
            w.println(_data);
        }
    }

    public static void main(String[] _args) throws Exception {
        String addr = null;
        String pidfile = null;
        String addrfile = null;
        boolean printaddress = false;
        boolean unix = true;
        boolean tcp = false;
        try {
            for (int i = 0; i < _args.length; ++i) {
                if ("--help".equals(_args[i]) || "-h".equals(_args[i])) {
                    DBusDaemon.syntax();
                    continue;
                }
                if ("--version".equals(_args[i]) || "-v".equals(_args[i])) {
                    DBusDaemon.version();
                    continue;
                }
                if ("--listen".equals(_args[i]) || "-l".equals(_args[i])) {
                    addr = _args[++i];
                    continue;
                }
                if ("--pidfile".equals(_args[i]) || "-p".equals(_args[i])) {
                    pidfile = _args[++i];
                    continue;
                }
                if ("--addressfile".equals(_args[i]) || "-a".equals(_args[i])) {
                    addrfile = _args[++i];
                    continue;
                }
                if ("--print-address".equals(_args[i]) || "-r".equals(_args[i])) {
                    printaddress = true;
                    continue;
                }
                if ("--unix".equals(_args[i]) || "-u".equals(_args[i])) {
                    unix = true;
                    tcp = false;
                    continue;
                }
                if ("--tcp".equals(_args[i]) || "-t".equals(_args[i])) {
                    tcp = true;
                    unix = false;
                    continue;
                }
                DBusDaemon.syntax();
            }
        }
        catch (ArrayIndexOutOfBoundsException exAioob) {
            DBusDaemon.syntax();
        }
        if (null == addr && unix) {
            addr = TransportBuilder.createDynamicSession("UNIX", true);
        } else if (null == addr && tcp) {
            addr = TransportBuilder.createDynamicSession("TCP", true);
        }
        BusAddress address = BusAddress.of(addr);
        if (printaddress) {
            System.out.println(addr);
        }
        if (null != addrfile) {
            DBusDaemon.saveFile(addr, addrfile);
        }
        if (null != pidfile) {
            DBusDaemon.saveFile(System.getProperty("Pid"), pidfile);
        }
        LOGGER.info("Binding to {}", (Object)addr);
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(address);){
            daemon.startInForeground();
        }
    }

    private DBusSignal generateNameAcquiredSignal(String _name) throws DBusException {
        return new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", _name);
    }

    private DBusSignal generatedNameOwnerChangedSignal(String _name, String _oldOwner, String _newOwner) throws DBusException {
        return new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", _name, _oldOwner, _newOwner);
    }

    static class MagicMap<A, B> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Map<A, LinkedList<B>> m = new HashMap<A, LinkedList<B>>();
        private final LinkedList<A> q = new LinkedList();
        private final String name;

        MagicMap(String _name) {
            this.name = _name;
        }

        public A head() {
            return this.q.getFirst();
        }

        public void putFirst(A _a, B _b) {
            this.logger.debug("<{}> Queueing {{} => {}}", new Object[]{this.name, _a, _b});
            if (this.m.containsKey(_a)) {
                this.m.get(_a).add(_b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(_b);
                this.m.put(_a, l);
            }
            this.q.addFirst(_a);
        }

        public void putLast(A _a, B _b) {
            this.logger.debug("<{}> Queueing {{} => {}}", new Object[]{this.name, _a, _b});
            if (this.m.containsKey(_a)) {
                this.m.get(_a).add(_b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(_b);
                this.m.put(_a, l);
            }
            this.q.addLast(_a);
        }

        public List<B> remove(A _a) {
            this.logger.debug("<{}> Removing {{}}", (Object)this.name, _a);
            this.q.remove(_a);
            return this.m.remove(_a);
        }

        public int size() {
            return this.q.size();
        }
    }

    public class DBusServer
    extends Thread
    implements DBus,
    Introspectable,
    Peer {
        private final String machineId;
        private ConnectionStruct connStruct;
        private volatile AtomicBoolean running = new AtomicBoolean(true);

        public DBusServer() {
            Object ascii;
            this.setName("DBusServer");
            try {
                ascii = Hexdump.toAscii(MessageDigest.getInstance("MD5").digest(InetAddress.getLocalHost().getHostName().getBytes()));
            }
            catch (UnknownHostException | NoSuchAlgorithmException _ex) {
                ascii = "" + this.hashCode();
            }
            this.machineId = ascii;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String Hello() {
            ConnectionStruct connectionStruct = this.connStruct;
            synchronized (connectionStruct) {
                if (null != this.connStruct.unique) {
                    throw new AccessDenied("Connection has already sent a Hello message");
                }
                Object object = DBusDaemon.this.uniqueLock;
                synchronized (object) {
                    this.connStruct.unique = ":1." + ++DBusDaemon.this.nextUnique;
                }
            }
            DBusDaemon.this.names.put(this.connStruct.unique, this.connStruct);
            LOGGER.info("Client {} registered", (Object)this.connStruct.unique);
            try {
                DBusDaemon.this.send(this.connStruct, DBusDaemon.this.generateNameAcquiredSignal(this.connStruct.unique));
                DBusDaemon.this.send(null, DBusDaemon.this.generatedNameOwnerChangedSignal(this.connStruct.unique, "", this.connStruct.unique));
            }
            catch (DBusException dbe) {
                LOGGER.debug("", (Throwable)dbe);
            }
            return this.connStruct.unique;
        }

        @Override
        public String[] ListNames() {
            Set<String> nss = DBusDaemon.this.names.keySet();
            String[] ns = nss.toArray(new String[0]);
            return ns;
        }

        @Override
        public boolean NameHasOwner(String _name) {
            return DBusDaemon.this.names.containsKey(_name);
        }

        @Override
        public String GetNameOwner(String _name) {
            ConnectionStruct owner = DBusDaemon.this.names.get(_name);
            String o = null == owner ? "" : owner.unique;
            return o;
        }

        @Override
        public UInt32 GetConnectionUnixUser(String _connectionName) {
            return new UInt32(0L);
        }

        @Override
        public UInt32 StartServiceByName(String _name, UInt32 _flags) {
            return new UInt32(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 RequestName(String _name, UInt32 _flags) {
            int rv;
            boolean exists = false;
            Map<String, ConnectionStruct> map = DBusDaemon.this.names;
            synchronized (map) {
                exists = DBusDaemon.this.names.containsKey(_name);
                if (!exists) {
                    DBusDaemon.this.names.put(_name, this.connStruct);
                }
            }
            if (exists) {
                rv = 3;
            } else {
                LOGGER.info("Client {} acquired name {}", (Object)this.connStruct.unique, (Object)_name);
                rv = 1;
                try {
                    DBusDaemon.this.send(this.connStruct, DBusDaemon.this.generateNameAcquiredSignal(_name));
                    DBusDaemon.this.send(null, DBusDaemon.this.generatedNameOwnerChangedSignal(_name, "", this.connStruct.unique));
                }
                catch (DBusException dbe) {
                    LOGGER.debug("", (Throwable)dbe);
                }
            }
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 ReleaseName(String _name) {
            int rv;
            boolean exists = false;
            Map<String, ConnectionStruct> map = DBusDaemon.this.names;
            synchronized (map) {
                if (DBusDaemon.this.names.containsKey(_name) && DBusDaemon.this.names.get(_name).equals(this.connStruct)) {
                    exists = DBusDaemon.this.names.remove(_name) != null;
                }
            }
            if (!exists) {
                rv = 2;
            } else {
                LOGGER.info("Client {} acquired name {}", (Object)this.connStruct.unique, (Object)_name);
                rv = 1;
                try {
                    DBusDaemon.this.send(this.connStruct, new DBus.NameLost("/org/freedesktop/DBus", _name));
                    DBusDaemon.this.send(null, new DBus.NameOwnerChanged("/org/freedesktop/DBus", _name, this.connStruct.unique, ""));
                }
                catch (DBusException dbe) {
                    LOGGER.debug("", (Throwable)dbe);
                }
            }
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddMatch(String _matchrule) throws MatchRuleInvalid {
            LOGGER.trace("Adding match rule: {}", (Object)_matchrule);
            List<ConnectionStruct> list = DBusDaemon.this.sigrecips;
            synchronized (list) {
                if (!DBusDaemon.this.sigrecips.contains(this.connStruct)) {
                    DBusDaemon.this.sigrecips.add(this.connStruct);
                }
            }
        }

        @Override
        public void RemoveMatch(String _matchrule) throws MatchRuleInvalid {
            LOGGER.trace("Removing match rule: {}", (Object)_matchrule);
        }

        @Override
        public String[] ListQueuedOwners(String _name) {
            return new String[0];
        }

        @Override
        public UInt32 GetConnectionUnixProcessID(String _connectionName) {
            return new UInt32(0L);
        }

        @Override
        public Byte[] GetConnectionSELinuxSecurityContext(String _args) {
            return new Byte[0];
        }

        private void handleMessage(ConnectionStruct _connStruct, Message _msg) throws DBusException {
            block9: {
                LOGGER.trace("Handling message {}  from {}", (Object)_msg, (Object)_connStruct.unique);
                if (!(_msg instanceof MethodCall)) {
                    return;
                }
                Object[] args = _msg.getParameters();
                Class[] cs = new Class[args.length];
                for (int i = 0; i < cs.length; ++i) {
                    cs[i] = args[i].getClass();
                }
                Method meth = null;
                Object rv = null;
                try {
                    meth = DBusServer.class.getMethod(_msg.getName(), cs);
                    try {
                        this.connStruct = _connStruct;
                        rv = meth.invoke((Object)DBusDaemon.this.dbusServer, args);
                        if (null == rv) {
                            DBusDaemon.this.send(_connStruct, new MethodReturn("org.freedesktop.DBus", (MethodCall)_msg, null, new Object[0]), true);
                            break block9;
                        }
                        String sig = Marshalling.getDBusType(meth.getGenericReturnType())[0];
                        DBusDaemon.this.send(_connStruct, new MethodReturn("org.freedesktop.DBus", (MethodCall)_msg, sig, rv), true);
                    }
                    catch (InvocationTargetException _exIte) {
                        LOGGER.debug("", (Throwable)_exIte);
                        DBusDaemon.this.send(_connStruct, new Error("org.freedesktop.DBus", _msg, _exIte.getCause()));
                    }
                    catch (DBusExecutionException _exDnEe) {
                        LOGGER.debug("", (Throwable)_exDnEe);
                        DBusDaemon.this.send(_connStruct, new Error("org.freedesktop.DBus", _msg, _exDnEe));
                    }
                    catch (Exception _ex) {
                        LOGGER.debug("", (Throwable)_ex);
                        DBusDaemon.this.send(_connStruct, new Error("org.freedesktop.DBus", _connStruct.unique, "org.freedesktop.DBus.Error.GeneralError", _msg.getSerial(), "s", "An error occurred while calling " + _msg.getName()));
                    }
                }
                catch (NoSuchMethodException _exNsm) {
                    DBusDaemon.this.send(_connStruct, new Error("org.freedesktop.DBus", _connStruct.unique, "org.freedesktop.DBus.Error.UnknownMethod", _msg.getSerial(), "s", "This service does not support " + _msg.getName()));
                }
            }
        }

        @Override
        public String getObjectPath() {
            return null;
        }

        @Override
        public String Introspect() {
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n<node>\n  <interface name=\"org.freedesktop.DBus.Introspectable\">\n    <method name=\"Introspect\">\n      <arg name=\"data\" direction=\"out\" type=\"s\"/>\n    </method>\n  </interface>\n  <interface name=\"org.freedesktop.DBus\">\n    <method name=\"RequestName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"ReleaseName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"StartServiceByName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"Hello\">\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"NameHasOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"b\"/>\n    </method>\n    <method name=\"ListNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"ListActivatableNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"AddMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"RemoveMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"GetNameOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"ListQueuedOwners\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"GetConnectionUnixUser\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionUnixProcessID\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionSELinuxSecurityContext\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"ay\"/>\n    </method>\n    <method name=\"ReloadConfig\">\n    </method>\n    <signal name=\"NameOwnerChanged\">\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameLost\">\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameAcquired\">\n      <arg type=\"s\"/>\n    </signal>\n  </interface>\n</node>";
        }

        @Override
        public void Ping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this.isRunning() && this.running.get()) {
                List<WeakReference<ConnectionStruct>> wcs;
                Message msg;
                MagicMap<Message, WeakReference<ConnectionStruct>> magicMap = DBusDaemon.this.localqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.localqueue.size() == 0) {
                        try {
                            DBusDaemon.this.localqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    msg = DBusDaemon.this.localqueue.head();
                    wcs = DBusDaemon.this.localqueue.remove(msg);
                }
                if (null != wcs) {
                    try {
                        for (WeakReference weakReference : wcs) {
                            ConnectionStruct constructor = (ConnectionStruct)weakReference.get();
                            if (null == constructor) continue;
                            LOGGER.trace("<localqueue> Got message {} from {}", (Object)msg, (Object)constructor);
                            this.handleMessage(constructor, msg);
                        }
                        continue;
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                        continue;
                    }
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.info("Discarding {} connection reaped", (Object)msg);
            }
        }

        public void terminate() {
            this.running.set(false);
            this.interrupt();
        }

        @Override
        public String[] ListActivatableNames() {
            return null;
        }

        @Override
        public Map<String, Variant<?>> GetConnectionCredentials(String _busName) {
            return null;
        }

        @Override
        public Byte[] GetAdtAuditSessionData(String _busName) {
            return null;
        }

        @Override
        public void UpdateActivationEnvironment(Map<String, String>[] _environment) {
        }

        @Override
        public String GetId() {
            return null;
        }

        @Override
        public String GetMachineId() {
            return this.machineId;
        }
    }

    public class DBusDaemonSenderThread
    extends Thread {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private volatile AtomicBoolean running = new AtomicBoolean(true);

        public DBusDaemonSenderThread() {
            this.setName(this.getClass().getSimpleName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this.isRunning() && this.running.get()) {
                this.logger.trace("Acquiring lock on outqueue and blocking for data");
                Message m = null;
                List<WeakReference<ConnectionStruct>> wcs = null;
                MagicMap<Message, WeakReference<ConnectionStruct>> magicMap = DBusDaemon.this.outqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.outqueue.size() == 0) {
                        try {
                            DBusDaemon.this.outqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    m = DBusDaemon.this.outqueue.head();
                    wcs = DBusDaemon.this.outqueue.remove(m);
                }
                if (null != wcs) {
                    for (WeakReference weakReference : wcs) {
                        ConnectionStruct c = (ConnectionStruct)weakReference.get();
                        if (null == c) continue;
                        this.logger.debug("<outqueue> Got message {} for {}", (Object)m, (Object)c.unique);
                        try {
                            c.outputWriter.writeMessage(m);
                        }
                        catch (IOException ioe) {
                            this.logger.debug("", (Throwable)ioe);
                            DBusDaemon.this.removeConnection(c);
                        }
                    }
                    continue;
                }
                this.logger.info("Discarding {} connection reaped", (Object)m);
            }
        }

        public synchronized void terminate() {
            this.running.set(false);
            this.interrupt();
        }
    }

    public static class ConnectionStruct {
        private final InputStreamMessageReader inputReader;
        private final OutputStreamMessageWriter outputWriter;
        private final SocketChannel socketChannel;
        private String unique;

        ConnectionStruct(SocketChannel _sock) throws IOException {
            this.socketChannel = _sock;
            this.inputReader = new InputStreamMessageReader(this.socketChannel);
            this.outputWriter = new OutputStreamMessageWriter(this.socketChannel);
        }

        public String toString() {
            return null == this.unique ? ":?-?" : this.unique;
        }
    }

    public class DBusDaemonReaderThread
    extends Thread {
        private ConnectionStruct conn;
        private final WeakReference<ConnectionStruct> weakconn;
        private volatile boolean lrun = true;

        public DBusDaemonReaderThread(ConnectionStruct _conn) {
            this.conn = _conn;
            this.weakconn = new WeakReference<ConnectionStruct>(_conn);
            this.setName(this.getClass().getSimpleName());
        }

        public void stopRunning() {
            this.lrun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this.isRunning() && this.lrun) {
                Message m;
                block7: {
                    m = null;
                    try {
                        m = this.conn.inputReader.readMessage();
                    }
                    catch (IOException ioe) {
                        LOGGER.debug("", (Throwable)ioe);
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                    catch (DBusException dbe) {
                        LOGGER.debug("", (Throwable)dbe);
                        if (!(dbe instanceof FatalException)) break block7;
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                }
                if (null == m) continue;
                DBusDaemon.this.logMessage("Read {} from {}", m, this.conn.unique);
                MagicMap<Message, WeakReference<ConnectionStruct>> magicMap = DBusDaemon.this.inqueue;
                synchronized (magicMap) {
                    DBusDaemon.this.inqueue.putLast(m, this.weakconn);
                    DBusDaemon.this.inqueue.notifyAll();
                }
            }
            this.conn = null;
        }
    }
}

