/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.nio.ByteOrder;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.BaseConnectionBuilder;
import org.freedesktop.dbus.connections.impl.DirectConnection;
import org.freedesktop.dbus.exceptions.DBusException;

public final class DirectConnectionBuilder
extends BaseConnectionBuilder<DirectConnectionBuilder, DirectConnection> {
    private DirectConnectionBuilder(BusAddress _address) {
        super(DirectConnectionBuilder.class, _address);
    }

    public static DirectConnectionBuilder forAddress(String _address) {
        DirectConnectionBuilder instance = new DirectConnectionBuilder(BusAddress.of(_address));
        return instance;
    }

    @Override
    public DirectConnection build() throws DBusException {
        ReceivingServiceConfig rsCfg = this.buildThreadConfig();
        TransportConfig transportCfg = this.buildTransportConfig();
        DirectConnection c = new DirectConnection(transportCfg, rsCfg);
        c.setDisconnectCallback(this.getDisconnectCallback());
        c.setWeakReferences(this.isWeakReference());
        DirectConnection.setEndianness(this.getEndianess());
        return c;
    }

    @Deprecated(forRemoval=true, since="4.2.0")
    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }
}

