/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.matchrules.MatchRuleField;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.constants.MessageTypes;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.freedesktop.dbus.utils.DBusObjects;
import org.freedesktop.dbus.utils.Util;

@Deprecated(forRemoval=true, since="5.2.0 - 2025-05-03")
public final class DBusMatchRule
extends org.freedesktop.dbus.matchrules.DBusMatchRule {
    private static final Map<String, Class<? extends DBusSignal>> SIGNALTYPEMAP = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private static final List<Function<DBusMatchRule, String>> MATCHRULE_EQUALS_OPERATIONS = List.of(org.freedesktop.dbus.matchrules.DBusMatchRule::getInterface, org.freedesktop.dbus.matchrules.DBusMatchRule::getMember, org.freedesktop.dbus.matchrules.DBusMatchRule::getPath, org.freedesktop.dbus.matchrules.DBusMatchRule::getSender, org.freedesktop.dbus.matchrules.DBusMatchRule::getDestination);

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(String _type, String _iface, String _member) {
        this(_type, _iface, _member, null);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(String _type, String _iface, String _member, String _path) {
        this(_type, _iface, _member, _path, null);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(String _type, String _iface, String _member, String _path, String _destination) {
        super(Stream.of(MatchRuleField.TYPE.entryOf(_type), MatchRuleField.INTERFACE.entryOf(_iface), MatchRuleField.MEMBER.entryOf(_member), MatchRuleField.PATH.entryOf(_path), MatchRuleField.DESTINATION.entryOf(_destination)).filter(Objects::nonNull).collect(Collectors.toMap(e -> (MatchRuleField)((Object)((Object)e.getKey())), e -> (String)e.getValue())), null);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(DBusExecutionException _e) throws DBusException {
        this(_e.getClass());
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(Message _m) {
        super(Stream.of(MatchRuleField.INTERFACE.entryOf(_m.getInterface()), MatchRuleField.MEMBER.entryOf(_m instanceof Error ? null : _m.getName()), MatchRuleField.TYPE.entryOf(MessageTypes.getRuleNameById(_m.getType())), MatchRuleField.DESTINATION.entryOf(_m.getDestination())).filter(Objects::nonNull).collect(Collectors.toMap(e -> (MatchRuleField)((Object)((Object)e.getKey())), e -> (String)e.getValue())), null);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(Class<? extends DBusInterface> _c, String _method) throws DBusException {
        this(_c, null, null, MessageTypes.METHOD_CALL.getMatchRuleName(), _method);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    DBusMatchRule(Class<?> _c, String _sender, String _path, String _type, String _member) throws DBusException {
        super(DBusMatchRule.legacyCompat(_c, _sender, _path, _type, _member), null);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(Class<?> _c, String _source, String _object) throws DBusException {
        this(_c, _source, _object, null, null);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public DBusMatchRule(Class<?> _c) throws DBusException {
        this(_c, null, null);
    }

    static Map<MatchRuleField, String> legacyCompat(Class<?> _c, String _sender, String _path, String _type, String _member) throws DBusException {
        LinkedHashMap<MatchRuleField, String> values = new LinkedHashMap<MatchRuleField, String>();
        if (DBusInterface.class.isAssignableFrom(_c)) {
            values.put(MatchRuleField.INTERFACE, DBusObjects.requireDBusInterface(DBusNamingUtil.getInterfaceName(_c)));
            values.put(MatchRuleField.MEMBER, _member);
            values.put(MatchRuleField.TYPE, _type);
        } else if (DBusSignal.class.isAssignableFrom(_c)) {
            if (null == _c.getEnclosingClass()) {
                throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
            }
            String interfaceName = DBusObjects.requireDBusInterface(DBusNamingUtil.getInterfaceName(_c.getEnclosingClass()));
            values.put(MatchRuleField.INTERFACE, interfaceName);
            String member = _member != null ? _member : DBusNamingUtil.getSignalName(_c);
            values.put(MatchRuleField.MEMBER, member);
            SIGNALTYPEMAP.put(interfaceName + "$" + member, _c);
            values.put(MatchRuleField.TYPE, _type != null ? _type : MessageTypes.SIGNAL.getMatchRuleName());
        } else if (Error.class.isAssignableFrom(_c) || DBusExecutionException.class.isAssignableFrom(_c)) {
            values.put(MatchRuleField.INTERFACE, DBusObjects.requireDBusInterface(DBusNamingUtil.getInterfaceName(_c)));
            values.put(MatchRuleField.MEMBER, _member);
            values.put(MatchRuleField.TYPE, _type != null ? _type : MessageTypes.ERROR.getMatchRuleName());
        } else {
            throw new DBusException("Invalid type for match rule: " + String.valueOf(_c));
        }
        values.put(MatchRuleField.SENDER, _sender);
        values.put(MatchRuleField.PATH, _path);
        return values;
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-03")
    public static Class<? extends DBusSignal> getCachedSignalType(String _type) {
        return org.freedesktop.dbus.matchrules.DBusMatchRule.getCachedSignalType(_type);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public boolean matches(DBusMatchRule _rule, @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01") boolean _strict) {
        if (_rule == null) {
            return false;
        }
        String[] compareVals = new String[]{this.getInterface(), this.getMember(), this.getPath(), this.getSender()};
        for (int i = 0; i < compareVals.length; ++i) {
            Function<DBusMatchRule, String> function;
            if (compareVals[i] == null || Util.strEquals(compareVals[i], (function = MATCHRULE_EQUALS_OPERATIONS.get(i)).apply(_rule))) continue;
            return false;
        }
        return true;
    }

    public boolean matches(DBusSignal _signal, @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01") boolean _strict) {
        return super.matches(_signal);
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public String getSource() {
        return this.getSender();
    }

    @Deprecated(forRemoval=true, since="5.2.0 - 2025-05-01")
    public String getObject() {
        return this.getPath();
    }
}

