/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freedesktop.dbus.matchrules.MatchRuleField;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class DBusMatchRule {
    private static final Map<String, Class<? extends DBusSignal>> SIGNALTYPEMAP = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private final Map<MatchRuleField, String> fields = new TreeMap<MatchRuleField, String>();
    private final Map<MatchRuleField, Map<Integer, String>> multiValueFields = new TreeMap<MatchRuleField, Map<Integer, String>>();

    protected DBusMatchRule(Map<MatchRuleField, String> _values, Map<MatchRuleField, Map<Integer, String>> _multiValues) {
        this.fields.putAll(Objects.requireNonNull(_values, "Values required"));
        if (_multiValues != null) {
            this.multiValueFields.putAll(_multiValues);
        }
    }

    public String getMessageType() {
        return this.fields.get((Object)MatchRuleField.TYPE);
    }

    public String getInterface() {
        return this.fields.get((Object)MatchRuleField.INTERFACE);
    }

    public String getMember() {
        return this.fields.get((Object)MatchRuleField.MEMBER);
    }

    public String getSender() {
        return this.fields.get((Object)MatchRuleField.SENDER);
    }

    public String getPath() {
        return this.fields.get((Object)MatchRuleField.PATH);
    }

    public String getDestination() {
        return this.fields.get((Object)MatchRuleField.DESTINATION);
    }

    public Map<Integer, String> getArg0123() {
        return this.getMultiValue(MatchRuleField.ARG0123);
    }

    public Map<Integer, String> getArg0123Path() {
        return this.getMultiValue(MatchRuleField.ARG0123PATH);
    }

    private Map<Integer, String> getMultiValue(MatchRuleField _field) {
        Map<Integer, String> map = this.multiValueFields.get((Object)_field);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return null;
    }

    public boolean matches(Message _msg) {
        if (_msg == null) {
            return false;
        }
        for (Map.Entry<MatchRuleField, String> entry : this.fields.entrySet()) {
            if (entry.getKey().getSingleMatcher().test(_msg, entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<MatchRuleField, Object> entry : this.multiValueFields.entrySet()) {
            if (entry.getKey().getMultiMatcher().test(_msg, (Map)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.multiValueFields);
    }

    public boolean equals(Object _obj) {
        if (this == _obj) {
            return true;
        }
        if (_obj == null) {
            return false;
        }
        if (this.getClass() != _obj.getClass()) {
            return false;
        }
        DBusMatchRule other = (DBusMatchRule)_obj;
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.multiValueFields, other.multiValueFields);
    }

    public String toString() {
        return Stream.concat(this.fields.entrySet().stream().filter(e -> e.getValue() != null).map(e -> Map.entry(((MatchRuleField)((Object)((Object)e.getKey()))).name().toLowerCase(Locale.US), (String)e.getValue())), this.multiValueFields.entrySet().stream().filter(e -> e.getValue() != null).flatMap(e -> {
            String baseName = ((MatchRuleField)((Object)((Object)e.getKey()))).name().toLowerCase(Locale.US);
            return ((Map)e.getValue()).entrySet().stream().filter(x -> x.getValue() != null).map(x -> Map.entry(baseName.replace("0123", String.valueOf(x.getKey())), (String)x.getValue()));
        })).map(e -> "%s='%s'".formatted(e.getKey(), DBusMatchRule.formatValue((String)e.getValue()))).collect(Collectors.joining(","));
    }

    static String formatValue(String _val) {
        return _val == null ? null : _val.replace("\\", "\\\\").replace("'", "\\'");
    }

    public static Class<? extends DBusSignal> getCachedSignalType(String _type) {
        return SIGNALTYPEMAP.get(_type);
    }

    static void addToTypeMap(String _key, Class<? extends DBusSignal> _clz) {
        SIGNALTYPEMAP.put(_key, _clz);
    }
}

