/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.matchrules.DBusMatchRule;
import org.freedesktop.dbus.matchrules.MatchRuleField;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.constants.MessageTypes;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.freedesktop.dbus.utils.DBusObjects;

public final class DBusMatchRuleBuilder {
    private final Map<MatchRuleField, String> values = new LinkedHashMap<MatchRuleField, String>();
    private final Map<MatchRuleField, Map<Integer, String>> multiValueFields = new LinkedHashMap<MatchRuleField, Map<Integer, String>>();

    private DBusMatchRuleBuilder() {
    }

    public DBusMatchRuleBuilder withSender(String _sender) {
        return this.putOrRemove(MatchRuleField.SENDER, _sender);
    }

    public DBusMatchRuleBuilder withDestination(String _destination) {
        return this.putOrRemove(MatchRuleField.DESTINATION, _destination);
    }

    public DBusMatchRuleBuilder withPath(String _path) {
        if (this.values.get((Object)MatchRuleField.PATH_NAMESPACE) != null && _path != null) {
            throw new IllegalArgumentException("Path and PathNamespace cannot be set at the same time");
        }
        return this.putOrRemove(MatchRuleField.PATH, _path);
    }

    public DBusMatchRuleBuilder withInterface(String _interface) {
        return this.putOrRemove(MatchRuleField.INTERFACE, _interface);
    }

    public DBusMatchRuleBuilder withMember(String _member) {
        return this.putOrRemove(MatchRuleField.MEMBER, _member);
    }

    public DBusMatchRuleBuilder withType(String _type) {
        if (Stream.of(MessageTypes.values()).map(e -> e.getMatchRuleName()).noneMatch(e -> e.equals(_type))) {
            throw new IllegalArgumentException(_type + " is not a valid message type");
        }
        return this.putOrRemove(MatchRuleField.TYPE, _type);
    }

    public DBusMatchRuleBuilder withType(MessageTypes _type) {
        if (_type == null) {
            this.values.remove((Object)MatchRuleField.TYPE);
        } else {
            this.values.put(MatchRuleField.TYPE, _type.getMatchRuleName());
        }
        return this;
    }

    public DBusMatchRuleBuilder withType(Class<?> _clz) throws DBusException {
        if (DBusInterface.class.isAssignableFrom(_clz)) {
            this.putOrRemove(MatchRuleField.INTERFACE, DBusObjects.requireDBusInterface(DBusNamingUtil.getInterfaceName(_clz)));
        } else if (DBusSignal.class.isAssignableFrom(_clz)) {
            if (_clz.getEnclosingClass() == null) {
                throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
            }
            String interfaceName = DBusObjects.requireDBusInterface(DBusNamingUtil.getInterfaceName(_clz.getEnclosingClass()));
            String signalName = DBusNamingUtil.getSignalName(_clz);
            DBusMatchRule.addToTypeMap(interfaceName + "$" + signalName, _clz);
            this.putOrRemove(MatchRuleField.INTERFACE, interfaceName);
            this.putOrRemove(MatchRuleField.MEMBER, signalName);
            this.putOrRemove(MatchRuleField.TYPE, MessageTypes.SIGNAL.getMatchRuleName());
        } else if (Error.class.isAssignableFrom(_clz) || DBusExecutionException.class.isAssignableFrom(_clz)) {
            this.putOrRemove(MatchRuleField.INTERFACE, DBusObjects.requireDBusInterface(DBusNamingUtil.getInterfaceName(_clz)));
            this.putOrRemove(MatchRuleField.TYPE, MessageTypes.ERROR.getMatchRuleName());
        } else {
            throw new DBusException("Invalid type for match rule: " + String.valueOf(_clz));
        }
        return this;
    }

    public DBusMatchRuleBuilder withArg0123(int _argId, String _arg0123) {
        return this.withArgX(MatchRuleField.ARG0123, _argId, _arg0123);
    }

    public DBusMatchRuleBuilder withArg0123Path(int _argId, String _arg0123Path) {
        return this.withArgX(MatchRuleField.ARG0123PATH, _argId, _arg0123Path);
    }

    public DBusMatchRuleBuilder withArg0Namespace(String _arg0Namespace) {
        return this.putOrRemove(MatchRuleField.ARG0NAMESPACE, _arg0Namespace);
    }

    public DBusMatchRuleBuilder withPathNamespace(String _pathNamespace) {
        if (this.values.get((Object)MatchRuleField.PATH) != null && _pathNamespace != null) {
            throw new IllegalArgumentException("Path and PathNamespace cannot be set at the same time");
        }
        return this.putOrRemove(MatchRuleField.PATH_NAMESPACE, _pathNamespace);
    }

    public DBusMatchRule build() {
        if (this.values.isEmpty() && this.multiValueFields.isEmpty()) {
            throw new IllegalStateException("No rules defined");
        }
        return new DBusMatchRule(this.values, this.multiValueFields);
    }

    private DBusMatchRuleBuilder putOrRemove(MatchRuleField _field, String _val) {
        if (_val == null) {
            this.values.remove((Object)_field);
        } else {
            this.values.put(_field, _val);
        }
        return this;
    }

    private DBusMatchRuleBuilder withArgX(MatchRuleField _field, int _argId, String _argValue) {
        if (_argId > 63 || _argId < 0) {
            throw new IllegalArgumentException("ArgId must be between 0 and 63");
        }
        Map<Integer, String> map = this.multiValueFields.get((Object)_field);
        if (map != null) {
            if (_argValue == null) {
                map.remove(_argId);
            } else {
                map.put(_argId, _argValue);
            }
            if (map.isEmpty()) {
                this.multiValueFields.remove((Object)_field);
            }
        } else {
            if (_argValue == null) {
                return this;
            }
            this.multiValueFields.computeIfAbsent(_field, x -> new LinkedHashMap()).put(_argId, _argValue);
        }
        return this;
    }

    public static DBusMatchRuleBuilder create() {
        return new DBusMatchRuleBuilder();
    }

    DBusMatchRule fromMap(Map<String, String> _keyValues) {
        if (_keyValues == null) {
            return null;
        }
        HashMap<String, String> copy = new HashMap<String, String>(_keyValues);
        Map<String, MatchRuleField> names = Stream.of(MatchRuleField.values()).collect(Collectors.toMap(e -> e.name().toLowerCase(Locale.US), e -> e));
        names.forEach((k, v) -> {
            String val = (String)copy.remove(k);
            if (val != null) {
                this.values.putIfAbsent((MatchRuleField)((Object)v), val);
            }
        });
        if (!copy.isEmpty()) {
            Pattern argPattern = Pattern.compile("^arg([0-9]{1,2})$");
            Pattern argPathPattern = Pattern.compile("^arg([0-9]{1,2})path$");
            for (Map.Entry e2 : copy.entrySet()) {
                Matcher argMatcher = argPattern.matcher((CharSequence)e2.getKey());
                Matcher argPathMatcher = argPathPattern.matcher((CharSequence)e2.getKey());
                if (argMatcher.matches()) {
                    this.multiValueFields.computeIfAbsent(MatchRuleField.ARG0123, x -> new LinkedHashMap()).putIfAbsent(Integer.valueOf(argMatcher.group(1)), (String)e2.getValue());
                }
                if (!argPathMatcher.matches()) continue;
                this.multiValueFields.computeIfAbsent(MatchRuleField.ARG0123PATH, x -> new LinkedHashMap()).putIfAbsent(Integer.valueOf(argMatcher.group(1)), (String)e2.getValue());
            }
        }
        return this.build();
    }
}

