/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.utils.DBusObjects;
import org.freedesktop.dbus.utils.Util;

final class MatchRuleMatcher {
    private MatchRuleMatcher() {
    }

    static boolean matchArg0123(Message _msg, Map<Integer, String> _compare) {
        if (_msg == null || _compare == null || _compare.isEmpty()) {
            return false;
        }
        try {
            ArrayList<Type> dataType = new ArrayList<Type>();
            Marshalling.getJavaType(_msg.getSig(), dataType, -1);
            if (dataType.isEmpty()) {
                return false;
            }
            Object[] parameters = _msg.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Class clz;
                Object e;
                if (!_compare.containsKey(i) || !((e = dataType.get(i)) instanceof Class) || !(clz = (Class)e).isAssignableFrom(String.class)) continue;
                String compareVal = _compare.get(i);
                return compareVal == parameters[i] || compareVal.equals(parameters[i]);
            }
        }
        catch (DBusException _ex) {
            throw new DBusExecutionException("Unable to get parameters from signal", _ex);
        }
        return false;
    }

    static boolean matchArg0123Path(Message _msg, Map<Integer, String> _compare) {
        if (_msg == null || _compare == null || _compare.isEmpty()) {
            return false;
        }
        try {
            ArrayList<Type> dataType = new ArrayList<Type>();
            Marshalling.getJavaType(_msg.getSig(), dataType, -1);
            if (dataType.isEmpty()) {
                return false;
            }
            Object[] parameters = _msg.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String matchVal;
                Object e;
                if (!_compare.containsKey(i) || !((e = dataType.get(i)) instanceof Class)) continue;
                Class clz = (Class)e;
                if (clz.isAssignableFrom(String.class)) {
                    matchVal = (String)parameters[i];
                } else {
                    if (!clz.isAssignableFrom(DBusPath.class)) continue;
                    matchVal = ((DBusPath)parameters[i]).getPath();
                }
                String compareVal = _compare.get(i);
                return compareVal == matchVal || MatchRuleMatcher.matchesArg0Path(matchVal, compareVal);
            }
        }
        catch (DBusException _ex) {
            throw new DBusExecutionException("Unable to get parameters from signal", _ex);
        }
        return false;
    }

    private static boolean matchesArg0Path(String _matchVal, String _compareVal) {
        return "/".equals(_compareVal) || _matchVal.startsWith(_compareVal);
    }

    static boolean matchPathNamespace(String _input, String _compare) {
        String[] compareSplit;
        if (DBusObjects.validateNotObjectPath(_compare) || DBusObjects.validateNotObjectPath(_compare)) {
            return false;
        }
        if (!_input.startsWith(_compare)) {
            return false;
        }
        String[] inputSplit = _input.split("/");
        if (inputSplit.length < (compareSplit = _compare.split("/")).length) {
            return false;
        }
        for (int i = 0; i < compareSplit.length; ++i) {
            if (Util.strEquals(compareSplit[i], inputSplit[i])) continue;
            return false;
        }
        return true;
    }

    static boolean matchArg0Namespace(Message _msg, String _compare) {
        if (_msg == null || _compare == null) {
            return false;
        }
        if (_compare.contains(".") && !DBusObjects.validateBusName(_compare)) {
            return false;
        }
        try {
            Class clz;
            ArrayList<Type> dataType = new ArrayList<Type>();
            Marshalling.getJavaType(_msg.getSig(), dataType, -1);
            if (dataType.isEmpty()) {
                return false;
            }
            Object e = dataType.get(0);
            if (e instanceof Class && (clz = (Class)e).isAssignableFrom(String.class)) {
                Object[] parameters = _msg.getParameters();
                return parameters[0] == _compare || ((String)parameters[0]).startsWith(_compare);
            }
        }
        catch (DBusException _ex) {
            throw new DBusExecutionException("Unable to get parameters from signal", _ex);
        }
        return false;
    }
}

