/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.matchrules;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freedesktop.dbus.errors.MatchRuleInvalid;
import org.freedesktop.dbus.matchrules.DBusMatchRule;
import org.freedesktop.dbus.matchrules.DBusMatchRuleBuilder;

public final class MatchRuleParser {
    private static final Pattern PATTERN = Pattern.compile("(\\w+)=('(?:\\\\'|[^'])*')");

    private MatchRuleParser() {
    }

    public static DBusMatchRule convertMatchRule(String _ruleStr) {
        try {
            return DBusMatchRuleBuilder.create().fromMap(MatchRuleParser.parseMatchRule(_ruleStr));
        }
        catch (Exception _ex) {
            throw new MatchRuleInvalid("Matchrule \"" + _ruleStr + "\"string is invalid", _ex);
        }
    }

    public static Map<String, String> parseMatchRule(String _ruleStr) {
        if (_ruleStr == null || _ruleStr.isBlank()) {
            return Map.of();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Matcher matcher = PATTERN.matcher(_ruleStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            String rawVal = matcher.group(2);
            String val = rawVal.substring(1, rawVal.length() - 1);
            val = val.replace("\\'", "'");
            result.put(key, val);
        }
        return result;
    }
}

