/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PrimitiveUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(new ConcurrentHashMap<Class<Double>, Class<Double>>(Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Character.TYPE, Character.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class)));
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = Collections.unmodifiableMap(new ConcurrentHashMap<Class<Double>, Class<Double>>(Map.of(Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Character.class, Character.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE)));

    private PrimitiveUtils() {
    }

    public static Map<Class<?>, Class<?>> getPrimitiveToWrapperTypes() {
        return Collections.unmodifiableMap(PRIMITIVE_TO_WRAPPER);
    }

    public static Map<Class<?>, Class<?>> getWrapperToPrimitiveTypes() {
        return Collections.unmodifiableMap(WRAPPER_TO_PRIMITIVE);
    }

    public static boolean isCompatiblePrimitiveOrWrapper(Class<?> _clz1, Class<?> _clz2) {
        if (_clz1 == null || _clz2 == null) {
            return false;
        }
        if (_clz1 == _clz2) {
            return true;
        }
        if (_clz1.isPrimitive()) {
            Class<?> wrappedType = PRIMITIVE_TO_WRAPPER.get(_clz1);
            return wrappedType == _clz2;
        }
        if (_clz2.isPrimitive()) {
            Class<?> wrappedType = PRIMITIVE_TO_WRAPPER.get(_clz2);
            return wrappedType == _clz1;
        }
        return false;
    }
}

