/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.freedesktop.dbus.test.helper.structs.MarkTuple;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MarshallingTest
extends AbstractBaseTest {
    @Test
    public void parseComplexMessageReturnsCorrectTypes() throws DBusException {
        ArrayList temp = new ArrayList();
        Marshalling.getJavaType((String)"a(oa{sv})ao", temp, (int)-1);
        Assertions.assertEquals((int)2, (int)temp.size(), (String)"result must contain two types");
        Assertions.assertTrue((boolean)(temp.get(0) instanceof DBusListType));
        Assertions.assertTrue((boolean)(temp.get(1) instanceof DBusListType));
    }

    @Test
    public void parseStructReturnsCorrectParsedCharsCount() throws Exception {
        ArrayList temp = new ArrayList();
        int parsedCharsCount = Marshalling.getJavaType((String)"(oa{sv})ao", temp, (int)1);
        Assertions.assertEquals((int)8, (int)parsedCharsCount);
    }

    private static byte[] streamReader(String _file) throws IOException {
        return Files.readAllBytes(new File(_file).toPath());
    }

    @Test
    public void testMarshalling() throws Exception {
        Type[] types = null;
        if (null == types) {
            Constructor<?> con = IServicesChanged.ServicesChanged.class.getDeclaredConstructors()[0];
            Type[] ts = con.getGenericParameterTypes();
            types = new Type[ts.length - 1];
            for (int i = 1; i < ts.length; ++i) {
                if (ts[i] instanceof TypeVariable) {
                    Type[] typeArray = ((TypeVariable)ts[i]).getBounds();
                    int n = typeArray.length;
                    for (int j = 0; j < n; ++j) {
                        Type b;
                        types[i - 1] = b = typeArray[j];
                    }
                    continue;
                }
                types[i - 1] = ts[i];
            }
        }
        Message msg = MessageFactory.createMessage((byte)4, (byte[])MarshallingTest.streamReader("src/test/resources/" + ((Object)((Object)this)).getClass().getSimpleName() + "/connman_sample_buf.bin"), (byte[])MarshallingTest.streamReader("src/test/resources/" + ((Object)((Object)this)).getClass().getSimpleName() + "/connman_sample_header.bin"), (byte[])MarshallingTest.streamReader("src/test/resources/" + ((Object)((Object)this)).getClass().getSimpleName() + "/connman_sample_body.bin"), null);
        Object[] params = Marshalling.deSerializeParameters((Object[])msg.getParameters(), (Type[])types, null);
        MarshallingTest.assertTrue((boolean)(params[0] instanceof List), (String)"First param is not a List");
        MarshallingTest.assertTrue((boolean)(params[1] instanceof List), (String)"Second param is not a List");
    }

    @Test
    public void testDeserializeParametersWithTuple() throws Exception {
        Object[] ob = new Object[]{"rootfs.1", "marked slot rootfs.1 as good"};
        Method m = Installer.class.getDeclaredMethod("Mark", String.class, String.class);
        Type[] ts = new Type[]{m.getGenericReturnType()};
        Object[] params = Marshalling.deSerializeParameters((Object[])ob, (Type[])ts, null);
        MarshallingTest.assertTrue((boolean)(params[0] instanceof MarkTuple), (String)"First param is not a MarkTuple");
        MarkTuple mt = (MarkTuple)((Object)params[0]);
        MarshallingTest.assertEquals((Object)mt.getSlotName(), (Object)"rootfs.1", (String)"Slot name does not match after deSerialization");
        MarshallingTest.assertEquals((Object)mt.getMessage(), (Object)"marked slot rootfs.1 as good", (String)"Message does not match after deSerialization");
    }

    @DBusInterfaceName(value="net.connman.Manager")
    static interface IServicesChanged
    extends DBusInterface {

        public static class ServicesChanged
        extends DBusSignal {
            public final String objectPath;
            public final List<SomeData> changed;
            public final List<ObjectPath> removed;

            public ServicesChanged(String _objectPath, List<SomeData> _k, List<ObjectPath> _removedItems) throws DBusException {
                super(_objectPath, new Object[]{_k, _removedItems});
                this.objectPath = _objectPath;
                this.changed = _k;
                this.removed = _removedItems;
            }

            public String getObjectPath() {
                return this.objectPath;
            }

            public List<SomeData> getChanged() {
                return this.changed;
            }

            public List<ObjectPath> getRemoved() {
                return this.removed;
            }
        }
    }

    public static interface Installer
    extends DBusInterface {
        public MarkTuple Mark(String var1, String var2);
    }

    public static class SomeData
    extends Struct {
        @Position(value=0)
        public DBusPath objectPath;
        @Position(value=1)
        public Map<String, Variant<?>> properties;

        public SomeData(DBusPath objectPath, Map<String, Variant<?>> properties) {
            this.objectPath = objectPath;
            this.properties = properties;
        }

        DBusPath getObjectPath() {
            return this.objectPath;
        }

        void setObjectPath(DBusPath _objectPath) {
            this.objectPath = _objectPath;
        }

        Map<String, Variant<?>> getProperties() {
            return this.properties;
        }

        void setProperties(Map<String, Variant<?>> _properties) {
            this.properties = _properties;
        }
    }
}

