/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.signals.handler;

import java.util.concurrent.atomic.AtomicInteger;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.opentest4j.AssertionFailedError;

public abstract class AbstractSignalHandler<T extends DBusSignal>
implements DBusSigHandler<T> {
    private final AtomicInteger testRuns = new AtomicInteger(0);
    private final int expectedRuns;
    protected AssertionFailedError assertionError;

    public AbstractSignalHandler(int _expectedRuns) {
        this.expectedRuns = _expectedRuns;
    }

    protected abstract void handleImpl(T var1);

    public final void handle(T _s) {
        this.getTestRuns().incrementAndGet();
        this.setFailed(this.getExpectedRuns() > this.getActualTestRuns(), "Signal received to often.");
        System.out.println(this.getClass().getSimpleName() + " running");
        this.handleImpl(_s);
    }

    protected AtomicInteger getTestRuns() {
        return this.testRuns;
    }

    public int getActualTestRuns() {
        return this.testRuns.get();
    }

    public int getExpectedRuns() {
        return this.expectedRuns;
    }

    public void getAssertionError() {
        if (this.assertionError != null) {
            throw this.assertionError;
        }
    }

    protected void setFailed(boolean _condition, String _message) {
        if (_condition) {
            this.assertionError = new AssertionFailedError(_message);
            throw this.assertionError;
        }
    }

    protected void setFailed(boolean _condition, String _message, Exception _ex) {
        if (_condition) {
            this.assertionError = new AssertionFailedError(_message, (Throwable)_ex);
            throw this.assertionError;
        }
    }
}

