/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.junit.jupiter.api.Test;

public class DBusConnectionTest
extends AbstractDBusBaseTest {
    @Test
    public void test_busnames_should_be_auto_released_on_close_of_non_shared_connection() throws Exception {
        String busName = "org.freedesktop.dbus.test.TestBus";
        DBusConnection connection1 = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        DBusConnection connection2 = DBusConnectionBuilder.forSessionBus().withShared(false).build();
        DBusConnectionTest.assertNotEquals((Object)connection1.getUniqueName(), (Object)connection2.getUniqueName());
        connection1.requestBusName(busName);
        DBusConnectionTest.assertThrows(DBusException.class, () -> connection2.requestBusName(busName));
        connection1.close();
        connection2.requestBusName(busName);
        connection2.close();
    }
}

