/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Test;

public class MapOfVariantTest
extends AbstractDBusBaseTest {
    @Test
    public void testMapOfVariant() throws IOException, DBusException {
        try (DBusConnection conn = DBusConnectionBuilder.forSessionBus().build();){
            MyVariantObject myVariantObject = new MyVariantObject();
            conn.requestBusName("org.freedesktop.dbus.test");
            conn.exportObject((DBusInterface)myVariantObject);
            MapVariant remoteObject = (MapVariant)conn.getRemoteObject("org.freedesktop.dbus.test", "/org/freedesktop/dbus/test/MyVariantObject", MapVariant.class);
            Map<String, Variant<?>> mapOfVariant = remoteObject.getMapOfVariant();
            MapOfVariantTest.assertTrue((boolean)mapOfVariant.containsKey("SomeString"));
            MapOfVariantTest.assertTrue((boolean)mapOfVariant.containsKey("SomeNumber"));
            MapOfVariantTest.assertEquals((Object)"Something", (Object)mapOfVariant.get("SomeString").getValue());
            MapOfVariantTest.assertEquals((Object)1, (Object)mapOfVariant.get("SomeNumber").getValue());
            HashMap newMap = new HashMap();
            newMap.put("overwrittenString", new Variant((Object)"other value"));
            newMap.put("overwrittenNumber", new Variant((Object)1000));
            remoteObject.setMapOfVariant(newMap);
            mapOfVariant = remoteObject.getMapOfVariant();
            MapOfVariantTest.assertTrue((boolean)mapOfVariant.containsKey("overwrittenString"));
            MapOfVariantTest.assertTrue((boolean)mapOfVariant.containsKey("overwrittenNumber"));
            MapOfVariantTest.assertEquals((Object)"other value", (Object)mapOfVariant.get("overwrittenString").getValue());
            MapOfVariantTest.assertEquals((Object)1000, (Object)mapOfVariant.get("overwrittenNumber").getValue());
        }
    }

    public static class MyVariantObject
    implements MapVariant {
        private Map<String, Variant<?>> variantMap = new HashMap();

        public MyVariantObject() {
            this.variantMap.put("SomeString", new Variant((Object)"Something"));
            this.variantMap.put("SomeNumber", new Variant((Object)1));
        }

        public String getObjectPath() {
            return "/org/freedesktop/dbus/test/MyVariantObject";
        }

        @Override
        public Map<String, Variant<?>> getMapOfVariant() {
            return this.variantMap;
        }

        @Override
        public void setMapOfVariant(Map<String, Variant<?>> _map) {
            this.variantMap = _map;
        }
    }

    @DBusInterfaceName(value="org.freedesktop.dbus.test.MapVariant")
    public static interface MapVariant
    extends DBusInterface {
        public Map<String, Variant<?>> getMapOfVariant();

        public void setMapOfVariant(Map<String, Variant<?>> var1);
    }
}

