/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.SampleClass;
import org.junit.jupiter.api.Test;

public class TestDisconnectCallback
extends AbstractDBusBaseTest {
    @Test
    public void testDisconnectCallback() throws DBusException, InterruptedException {
        TestCallback callback = new TestCallback();
        DBusConnection serverConnection = ((DBusConnectionBuilder)((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withDisconnectCallback((IDisconnectCallback)callback)).withWeakReferences(true)).build();
        DBusConnection clientConnection = ((DBusConnectionBuilder)((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withDisconnectCallback((IDisconnectCallback)callback)).withWeakReferences(true)).build();
        serverConnection.requestBusName("foo.bar.why.again.disconnect.Test");
        SampleClass tclass = new SampleClass(serverConnection);
        serverConnection.exportObject("/Test2001", (DBusInterface)tclass);
        clientConnection.disconnect();
        Thread.sleep(1000L);
        serverConnection.disconnect();
        Thread.sleep(1000L);
        TestDisconnectCallback.assertEquals((int)1, (int)callback.clientDisconnectCounter.get());
        TestDisconnectCallback.assertEquals((int)0, (int)callback.disconnectErrorCounter.get());
        TestDisconnectCallback.assertEquals((int)0, (int)callback.exceptionTerminateCounter.get());
        TestDisconnectCallback.assertEquals((int)1, (Integer)callback.expectedCounter.get(2));
        TestDisconnectCallback.assertEquals((int)1, (Integer)callback.expectedCounter.get(null));
    }

    static class TestCallback
    implements IDisconnectCallback {
        AtomicInteger clientDisconnectCounter = new AtomicInteger(0);
        Map<Integer, Integer> expectedCounter = new HashMap<Integer, Integer>();
        AtomicInteger disconnectErrorCounter = new AtomicInteger(0);
        AtomicInteger exceptionTerminateCounter = new AtomicInteger(0);

        TestCallback() {
        }

        public void clientDisconnect() {
            this.clientDisconnectCounter.incrementAndGet();
        }

        public void disconnectOnError(IOException _ex) {
            this.disconnectErrorCounter.incrementAndGet();
        }

        public void exceptionOnTerminate(IOException _ex) {
            this.exceptionTerminateCounter.incrementAndGet();
        }

        public void requestedDisconnect(Integer _connectionId) {
            Integer integer = this.expectedCounter.get(_connectionId);
            if (integer == null) {
                this.expectedCounter.put(_connectionId, 1);
            } else {
                Integer n = integer;
                integer = integer + 1;
                this.expectedCounter.put(_connectionId, n);
            }
        }
    }
}

