/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.cross;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.helper.interfaces.Binding;
import org.freedesktop.dbus.test.helper.interfaces.SamplesInterface;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossTestClient
implements Binding.SampleClient,
DBusSigHandler<Binding.SampleSignals.Triggered> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrossTestClient.class);
    private DBusConnection conn;
    public final Set<String> passed = new TreeSet<String>();
    public final Map<String, List<String>> failed = new HashMap<String, List<String>>();

    public CrossTestClient(DBusConnection _conn) {
        this.conn = _conn;
        ArrayList<String> l = new ArrayList<String>();
        l.add("Signal never arrived");
        this.failed.put("org.freedesktop.DBus.Binding.TestSignals.Triggered", l);
        l = new ArrayList();
        l.add("Method never called");
        this.failed.put("org.freedesktop.DBus.Binding.TestClient.Response", l);
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    public void handle(Binding.SampleSignals.Triggered t) {
        this.failed.remove("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        if (new UInt64(21389479283L).equals((Object)t.getSampleUint64()) && "/Test".equals(t.getPath())) {
            this.pass("org.freedesktop.DBus.Binding.TestSignals.Triggered");
        } else if (!new UInt64(21389479283L).equals((Object)t.getSampleUint64())) {
            this.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal content; expected 21389479283 got " + t.getSampleUint64());
        } else if (!"/Test".equals(t.getPath())) {
            this.fail("org.freedesktop.DBus.Binding.TestSignals.Triggered", "Incorrect signal source object; expected /Test got " + t.getPath());
        }
    }

    @Override
    public void Response(UInt16 a, double b) {
        this.failed.remove("org.freedesktop.DBus.Binding.TestClient.Response");
        if (a.equals((Object)new UInt16(15)) && b == 12.5) {
            this.pass("org.freedesktop.DBus.Binding.TestClient.Response");
        } else {
            this.fail("org.freedesktop.DBus.Binding.TestClient.Response", "Incorrect parameters; expected 15, 12.5 got " + a + ", " + b);
        }
    }

    public void pass(String test) {
        this.passed.add(test.replaceAll("[$]", "."));
    }

    public void fail(String test, String reason) {
        List<String> reasons = this.failed.get(test = test.replaceAll("[$]", "."));
        if (null == reasons) {
            reasons = new ArrayList<String>();
            this.failed.put(test, reasons);
        }
        reasons.add(reason);
    }

    public void test(Class<? extends DBusInterface> iface, Object proxy, String method, Object rv, Object ... parameters) {
        try {
            Method[] ms = iface.getMethods();
            Method m = null;
            for (Method t : ms) {
                if (!t.getName().equals(method)) continue;
                m = t;
                break;
            }
            Object o = m.invoke(proxy, parameters);
            Object msg = "Incorrect return value; sent ( ";
            if (null != parameters) {
                for (Object po : parameters) {
                    if (null == po) continue;
                    msg = (String)msg + CrossTestClient.collapseArray(po) + ",";
                }
            }
            msg = ((String)msg).replaceAll(".$", ");");
            msg = (String)msg + " expected " + CrossTestClient.collapseArray(rv) + " got " + CrossTestClient.collapseArray(o);
            if (null != rv && rv.getClass().isArray()) {
                this.compareArray(iface.getName() + "." + method, rv, o);
            } else if (rv instanceof Map) {
                if (o instanceof Map) {
                    Map a = (Map)o;
                    Map b = (Map)rv;
                    if (a.keySet().size() != b.keySet().size()) {
                        this.fail(iface.getName() + "." + method, (String)msg);
                    } else {
                        for (Object k : a.keySet()) {
                            if (a.get(k) instanceof List) {
                                if (b.get(k) instanceof List) {
                                    if (CrossTestClient.setCompareLists((List)a.get(k), (List)b.get(k))) continue;
                                    this.fail(iface.getName() + "." + method, (String)msg);
                                    continue;
                                }
                                this.fail(iface.getName() + "." + method, (String)msg);
                                continue;
                            }
                            if (a.get(k).equals(b.get(k))) continue;
                            this.fail(iface.getName() + "." + method, (String)msg);
                            return;
                        }
                    }
                    this.pass(iface.getName() + "." + method);
                } else {
                    this.fail(iface.getName() + "." + method, (String)msg);
                }
            } else if (o == rv || o != null && o.equals(rv)) {
                this.pass(iface.getName() + "." + method);
            } else {
                this.fail(iface.getName() + "." + method, (String)msg);
            }
        }
        catch (DBusExecutionException exDbe) {
            exDbe.printStackTrace();
            this.fail(iface.getName() + "." + method, "Error occurred during execution: " + ((Object)((Object)exDbe)).getClass().getName() + " " + exDbe.getMessage());
        }
        catch (InvocationTargetException exIt) {
            exIt.printStackTrace();
            this.fail(iface.getName() + "." + method, "Error occurred during execution: " + exIt.getCause().getClass().getName() + " " + exIt.getCause().getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail(iface.getName() + "." + method, "Error occurred during execution: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static String collapseArray(Object array) {
        if (null == array) {
            return "null";
        }
        if (array.getClass().isArray()) {
            Object s = "{ ";
            for (int i = 0; i < Array.getLength(array); ++i) {
                s = (String)s + CrossTestClient.collapseArray(Array.get(array, i)) + ",";
            }
            s = ((String)s).replaceAll(".$", " }");
            return s;
        }
        if (array instanceof List) {
            Object s = "{ ";
            for (Object o : (List)array) {
                s = (String)s + CrossTestClient.collapseArray(o) + ",";
            }
            s = ((String)s).replaceAll(".$", " }");
            return s;
        }
        if (array instanceof Map) {
            Object s = "{ ";
            for (Object o : ((Map)array).keySet()) {
                s = (String)s + CrossTestClient.collapseArray(o) + " => " + CrossTestClient.collapseArray(((Map)array).get(o)) + ",";
            }
            s = ((String)s).replaceAll(".$", " }");
            return s;
        }
        return array.toString();
    }

    public static <T> boolean setCompareLists(List<T> a, List<T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (T v : a) {
            if (b.contains(v)) continue;
            return false;
        }
        return true;
    }

    public static List<Variant<Object>> primitizeRecurse(Object a, Type t) {
        ArrayList<Variant<Object>> vs = new ArrayList<Variant<Object>>();
        if (t instanceof ParameterizedType) {
            Class c = (Class)((ParameterizedType)t).getRawType();
            if (List.class.isAssignableFrom(c)) {
                Object[] os = a instanceof List ? ((List)a).toArray() : a;
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                for (int i = 0; i < Array.getLength(os); ++i) {
                    vs.addAll(CrossTestClient.primitizeRecurse(Array.get(os, i), ts[0]));
                }
            } else if (Map.class.isAssignableFrom(c)) {
                Object[] os = ((Map)a).keySet().toArray();
                Object[] ks = ((Map)a).values().toArray();
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                for (Object element : ks) {
                    vs.addAll(CrossTestClient.primitizeRecurse(element, ts[0]));
                }
                for (Object element : os) {
                    vs.addAll(CrossTestClient.primitizeRecurse(element, ts[1]));
                }
            } else if (Struct.class.isAssignableFrom(c)) {
                Object[] os = ((Struct)a).getParameters();
                Type[] ts = ((ParameterizedType)t).getActualTypeArguments();
                for (int i = 0; i < os.length; ++i) {
                    vs.addAll(CrossTestClient.primitizeRecurse(os[i], ts[i]));
                }
            } else if (Variant.class.isAssignableFrom(c)) {
                vs.addAll(CrossTestClient.primitizeRecurse(((Variant)a).getValue(), ((Variant)a).getType()));
            }
        } else if (Variant.class.isAssignableFrom((Class)t)) {
            vs.addAll(CrossTestClient.primitizeRecurse(((Variant)a).getValue(), ((Variant)a).getType()));
        } else if (t instanceof Class && ((Class)t).isArray()) {
            Class<?> t2 = ((Class)t).getComponentType();
            for (int i = 0; i < Array.getLength(a); ++i) {
                vs.addAll(CrossTestClient.primitizeRecurse(Array.get(a, i), t2));
            }
        } else {
            vs.add(new Variant((Object)a));
        }
        return vs;
    }

    public List<Variant<Object>> primitize(Variant<Object> a) {
        return CrossTestClient.primitizeRecurse(a.getValue(), a.getType());
    }

    public void primitizeTest(SamplesInterface tests, Object input) {
        Variant in = new Variant(input);
        List<Variant<Object>> vs = this.primitize((Variant<Object>)in);
        try {
            List<Variant<Object>> res = tests.Primitize((Variant<Object>)in);
            if (CrossTestClient.setCompareLists(res, vs)) {
                this.pass("org.freedesktop.DBus.Binding.Tests.Primitize");
            } else {
                this.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Wrong Return Value; expected " + CrossTestClient.collapseArray(vs) + " got " + CrossTestClient.collapseArray(res));
            }
        }
        catch (Exception e) {
            LOGGER.debug("", (Throwable)e);
            this.fail("org.freedesktop.DBus.Binding.Tests.Primitize", "Exception occurred during test: (" + e.getClass().getName() + ") " + e.getMessage());
        }
    }

    public void doTests(Peer peer, Introspectable intro, Introspectable rootintro, SamplesInterface tests, Binding.SingleSample singletests) {
        Random r = new Random();
        this.test(Peer.class, peer, "Ping", null, new Object[0]);
        try {
            if (intro.Introspect().startsWith("<!DOCTYPE")) {
                this.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /Test");
            }
        }
        catch (DBusExecutionException dbee) {
            LOGGER.debug("", (Throwable)dbee);
            this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on /Test (" + ((Object)((Object)dbee)).getClass().getName() + "): " + dbee.getMessage());
        }
        try {
            if (rootintro.Introspect().startsWith("<!DOCTYPE")) {
                this.pass("org.freedesktop.DBus.Introspectable.Introspect");
            } else {
                this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Didn't get valid xml data back when introspecting /");
            }
        }
        catch (DBusExecutionException dbee) {
            LOGGER.debug("", (Throwable)dbee);
            this.fail("org.freedesktop.DBus.Introspectable.Introspect", "Got exception during introspection on / (" + ((Object)((Object)dbee)).getClass().getName() + "): " + dbee.getMessage());
        }
        this.test(SamplesInterface.class, tests, "Identity", new Variant((Object)1), new Variant((Object)1));
        this.test(SamplesInterface.class, tests, "Identity", new Variant((Object)"Hello"), new Variant((Object)"Hello"));
        this.test(SamplesInterface.class, tests, "IdentityBool", false, false);
        this.test(SamplesInterface.class, tests, "IdentityBool", true, true);
        this.test(SamplesInterface.class, tests, "Invert", false, true);
        this.test(SamplesInterface.class, tests, "Invert", true, false);
        this.test(SamplesInterface.class, tests, "IdentityByte", (byte)0, (byte)0);
        this.test(SamplesInterface.class, tests, "IdentityByte", (byte)1, (byte)1);
        this.test(SamplesInterface.class, tests, "IdentityByte", (byte)-1, (byte)-1);
        this.test(SamplesInterface.class, tests, "IdentityByte", (byte)127, (byte)127);
        this.test(SamplesInterface.class, tests, "IdentityByte", (byte)-128, (byte)-128);
        int i = r.nextInt();
        this.test(SamplesInterface.class, tests, "IdentityByte", (byte)i, (byte)i);
        this.test(SamplesInterface.class, tests, "IdentityInt16", (short)0, (short)0);
        this.test(SamplesInterface.class, tests, "IdentityInt16", (short)1, (short)1);
        this.test(SamplesInterface.class, tests, "IdentityInt16", (short)-1, (short)-1);
        this.test(SamplesInterface.class, tests, "IdentityInt16", (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
        this.test(SamplesInterface.class, tests, "IdentityInt16", (short)Short.MIN_VALUE, (short)Short.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, tests, "IdentityInt16", (short)i, (short)i);
        this.test(SamplesInterface.class, tests, "IdentityInt32", 0, 0);
        this.test(SamplesInterface.class, tests, "IdentityInt32", 1, 1);
        this.test(SamplesInterface.class, tests, "IdentityInt32", -1, -1);
        this.test(SamplesInterface.class, tests, "IdentityInt32", Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.test(SamplesInterface.class, tests, "IdentityInt32", Integer.MIN_VALUE, Integer.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, tests, "IdentityInt32", i, i);
        this.test(SamplesInterface.class, tests, "IdentityInt64", 0L, 0L);
        this.test(SamplesInterface.class, tests, "IdentityInt64", 1L, 1L);
        this.test(SamplesInterface.class, tests, "IdentityInt64", -1L, -1L);
        this.test(SamplesInterface.class, tests, "IdentityInt64", Long.MAX_VALUE, Long.MAX_VALUE);
        this.test(SamplesInterface.class, tests, "IdentityInt64", Long.MIN_VALUE, Long.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, tests, "IdentityInt64", i, i);
        this.test(SamplesInterface.class, tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        this.test(SamplesInterface.class, tests, "IdentityUInt16", new UInt16(1), new UInt16(1));
        this.test(SamplesInterface.class, tests, "IdentityUInt16", new UInt16(65535), new UInt16(65535));
        this.test(SamplesInterface.class, tests, "IdentityUInt16", new UInt16(0), new UInt16(0));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        this.test(SamplesInterface.class, tests, "IdentityUInt16", new UInt16(i % 65535), new UInt16(i % 65535));
        this.test(SamplesInterface.class, tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        this.test(SamplesInterface.class, tests, "IdentityUInt32", new UInt32(1L), new UInt32(1L));
        this.test(SamplesInterface.class, tests, "IdentityUInt32", new UInt32(0xFFFFFFFFL), new UInt32(0xFFFFFFFFL));
        this.test(SamplesInterface.class, tests, "IdentityUInt32", new UInt32(0L), new UInt32(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        this.test(SamplesInterface.class, tests, "IdentityUInt32", new UInt32((long)i % 0xFFFFFFFFL), new UInt32((long)i % 0xFFFFFFFFL));
        this.test(SamplesInterface.class, tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        this.test(SamplesInterface.class, tests, "IdentityUInt64", new UInt64(1L), new UInt64(1L));
        this.test(SamplesInterface.class, tests, "IdentityUInt64", new UInt64(Long.MAX_VALUE), new UInt64(Long.MAX_VALUE));
        this.test(SamplesInterface.class, tests, "IdentityUInt64", new UInt64(UInt64.MAX_BIG_VALUE), new UInt64(UInt64.MAX_BIG_VALUE));
        this.test(SamplesInterface.class, tests, "IdentityUInt64", new UInt64(0L), new UInt64(0L));
        i = r.nextInt();
        i = i > 0 ? i : -i;
        this.test(SamplesInterface.class, tests, "IdentityUInt64", new UInt64((long)i % Long.MAX_VALUE), new UInt64((long)i % Long.MAX_VALUE));
        this.test(SamplesInterface.class, tests, "IdentityDouble", 0.0, 0.0);
        this.test(SamplesInterface.class, tests, "IdentityDouble", 1.0, 1.0);
        this.test(SamplesInterface.class, tests, "IdentityDouble", -1.0, -1.0);
        this.test(SamplesInterface.class, tests, "IdentityDouble", Double.MAX_VALUE, Double.MAX_VALUE);
        this.test(SamplesInterface.class, tests, "IdentityDouble", Double.MIN_VALUE, Double.MIN_VALUE);
        i = r.nextInt();
        this.test(SamplesInterface.class, tests, "IdentityDouble", i, i);
        this.test(SamplesInterface.class, tests, "IdentityString", "", "");
        this.test(SamplesInterface.class, tests, "IdentityString", "The Quick Brown Fox Jumped Over The Lazy Dog", "The Quick Brown Fox Jumped Over The Lazy Dog");
        this.test(SamplesInterface.class, tests, "IdentityString", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093", "\u3072\u3089\u304c\u306a\u30b2\u30fc\u30e0 - \u304b\u306a\u3076\u3093");
        this.testArray(SamplesInterface.class, tests, "IdentityBoolArray", Boolean.TYPE, null);
        this.testArray(SamplesInterface.class, tests, "IdentityByteArray", Byte.TYPE, null);
        this.testArray(SamplesInterface.class, tests, "IdentityInt16Array", Short.TYPE, null);
        this.testArray(SamplesInterface.class, tests, "IdentityInt32Array", Integer.TYPE, null);
        this.testArray(SamplesInterface.class, tests, "IdentityInt64Array", Long.TYPE, null);
        this.testArray(SamplesInterface.class, tests, "IdentityDoubleArray", Double.TYPE, null);
        Variant content = new Variant((Object)"aoeu");
        this.testArray(SamplesInterface.class, tests, "IdentityArray", Variant.class, content);
        this.testArray(SamplesInterface.class, tests, "IdentityUInt16Array", UInt16.class, new UInt16(12));
        this.testArray(SamplesInterface.class, tests, "IdentityUInt32Array", UInt32.class, new UInt32(190L));
        this.testArray(SamplesInterface.class, tests, "IdentityUInt64Array", UInt64.class, new UInt64(103948L));
        this.testArray(SamplesInterface.class, tests, "IdentityStringArray", String.class, "asdf");
        int[] is = new int[]{};
        this.test(SamplesInterface.class, tests, "Sum", 0L, new Object[]{is});
        r = new Random();
        int len = r.nextInt() % 100 + 15;
        len = (len < 0 ? -len : len) + 15;
        is = new int[len];
        long result = 0L;
        for (i = 0; i < len; ++i) {
            is[i] = r.nextInt();
            result += (long)is[i];
        }
        this.test(SamplesInterface.class, tests, "Sum", result, new Object[]{is});
        byte[] bs = new byte[]{};
        this.test(Binding.SingleSample.class, singletests, "Sum", new UInt32(0L), new Object[]{bs});
        len = r.nextInt() % 100;
        len = (len < 0 ? -len : len) + 15;
        bs = new byte[len];
        int res = 0;
        for (i = 0; i < len; ++i) {
            bs[i] = (byte)r.nextInt();
            res += bs[i] < 0 ? bs[i] + 256 : bs[i];
        }
        this.test(Binding.SingleSample.class, singletests, "Sum", new UInt32((long)res % 0x100000000L), new Object[]{bs});
        this.test((Class<? extends DBusInterface>)SamplesInterface.class, tests, "DeStruct", new Binding.Triplet<String, UInt32, Short>("hi", new UInt32(12L), (short)99), new Object[]{new Binding.CrossSampleStruct("hi", new UInt32(12L), (short)99)});
        HashMap<String, String> in = new HashMap<String, String>();
        HashMap out = new HashMap();
        this.test(SamplesInterface.class, tests, "InvertMapping", out, in);
        in.put("hi", "there");
        in.put("to", "there");
        in.put("from", "here");
        in.put("in", "out");
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("to");
        out.put("there", l);
        l = new ArrayList();
        l.add("from");
        out.put("here", l);
        l = new ArrayList();
        l.add("in");
        out.put("out", l);
        this.test(SamplesInterface.class, tests, "InvertMapping", out, in);
        this.primitizeTest(tests, 1);
        this.primitizeTest(tests, new Variant((Object)new Variant((Object)new Variant((Object)new Variant((Object)"Hi")))));
        this.primitizeTest(tests, new Variant(in, (Type)new DBusMapType(String.class, String.class)));
        this.test(SamplesInterface.class, tests, "Trigger", null, "/Test", new UInt64(21389479283L));
        try {
            this.conn.sendMessage((Message)new Binding.SampleClient.Trigger("/Test", new UInt16(15), 12.5));
        }
        catch (DBusException dbe) {
            LOGGER.debug("", (Throwable)dbe);
            throw new DBusExecutionException(dbe.getMessage());
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.test(SamplesInterface.class, tests, "Exit", null, new Object[0]);
    }

    public void testArray(Class<? extends DBusInterface> iface, Object proxy, String method, Class<? extends Object> arrayType, Object content) {
        Object array = Array.newInstance(arrayType, 0);
        this.test(iface, proxy, method, array, array);
        Random r = new Random();
        int l = r.nextInt() % 100;
        array = Array.newInstance(arrayType, (l < 0 ? -l : l) + 15);
        if (null != content) {
            Arrays.fill((Object[])array, content);
        }
        this.test(iface, proxy, method, array, array);
    }

    public void compareArray(String test, Object a, Object b) {
        if (!a.getClass().equals(b.getClass())) {
            this.fail(test, "Incorrect return type; expected " + a.getClass() + " got " + b.getClass());
            return;
        }
        boolean pass = false;
        if (a instanceof Object[]) {
            pass = Arrays.equals((Object[])a, (Object[])b);
        } else if (a instanceof byte[]) {
            pass = Arrays.equals((byte[])a, (byte[])b);
        } else if (a instanceof boolean[]) {
            pass = Arrays.equals((boolean[])a, (boolean[])b);
        } else if (a instanceof int[]) {
            pass = Arrays.equals((int[])a, (int[])b);
        } else if (a instanceof short[]) {
            pass = Arrays.equals((short[])a, (short[])b);
        } else if (a instanceof long[]) {
            pass = Arrays.equals((long[])a, (long[])b);
        } else if (a instanceof double[]) {
            pass = Arrays.equals((double[])a, (double[])b);
        }
        if (pass) {
            this.pass(test);
        } else {
            Object s = "Incorrect return value; expected ";
            s = (String)s + CrossTestClient.collapseArray(a);
            s = (String)s + " got ";
            s = (String)s + CrossTestClient.collapseArray(b);
            this.fail(test, (String)s);
        }
    }

    public Set<String> getPassed() {
        return this.passed;
    }

    public Map<String, List<String>> getFailed() {
        return this.failed;
    }
}

