/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.io.IOException;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

public class SASLTest
extends AbstractBaseTest {
    @Test
    public void testCommandNoData() throws IOException {
        SASL.Command cmdData = new SASL.Command("DATA ");
        SASLTest.assertEquals((Object)SASL.SaslCommand.DATA, (Object)cmdData.getCommand());
        SASLTest.assertNull((Object)cmdData.getData());
    }

    @Test
    public void testCommandWithData() throws IOException {
        SASL.Command cmdData = new SASL.Command("DATA blafasel");
        SASLTest.assertEquals((Object)SASL.SaslCommand.DATA, (Object)cmdData.getCommand());
        SASLTest.assertEquals((Object)"blafasel", (Object)cmdData.getData());
    }

    @Test
    public void testCommandAuth() throws IOException {
        SASL.Command cmdData = new SASL.Command("AUTH ");
        SASLTest.assertEquals((Object)SASL.SaslCommand.AUTH, (Object)cmdData.getCommand());
        SASLTest.assertNull((Object)cmdData.getData());
    }

    @Test
    public void testAnonymousAuthentication() throws DBusException {
        String protocolType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
        String newAddress = TransportBuilder.createDynamicSession((String)protocolType, (boolean)false);
        BusAddress busAddress = BusAddress.of((String)newAddress);
        BusAddress listenBusAddress = BusAddress.of((String)(newAddress + ",listen=true"));
        this.logger.debug("Starting embedded bus on address {})", (Object)listenBusAddress);
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(listenBusAddress);){
            daemon.setSaslAuthMode(TransportBuilder.SaslAuthMode.AUTH_ANONYMOUS);
            daemon.startInBackground();
            this.logger.debug("Started embedded bus on address {}", (Object)listenBusAddress);
            SASLTest.waitForDaemon(daemon);
            this.logger.info("Connecting to embedded DBus {}", (Object)busAddress);
            try (DBusConnection conn = ((DBusConnectionBuilder)DBusConnectionBuilder.forAddress((BusAddress)busAddress).transportConfig().configureSasl().withAuthMode(TransportBuilder.SaslAuthMode.AUTH_ANONYMOUS).back().back()).build();){
                this.logger.debug("Connected to embedded DBus {}", (Object)busAddress);
                SASLTest.assertEquals((int)TransportBuilder.SaslAuthMode.AUTH_ANONYMOUS.getAuthMode(), (int)conn.getTransportConfig().getSaslConfig().getAuthMode());
            }
            catch (Exception _ex) {
                SASLTest.fail((String)"Connection to EmbeddedDbusDaemon failed", (Throwable)_ex);
                this.logger.error("Error connecting to EmbeddedDbusDaemon", (Throwable)_ex);
            }
        }
        catch (IOException _ex1) {
            SASLTest.fail((String)"Failed to start EmbeddedDbusDaemon", (Throwable)_ex1);
            this.logger.error("Error starting EmbeddedDbusDaemon", (Throwable)_ex1);
        }
    }
}

