/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.AddressResolvingException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NoTransportAddressTest {
    @Test
    public void testNoTransportAddress() {
        if (TransportBuilder.getRegisteredBusTypes().contains("TCP")) {
            AddressResolvingException ex = (AddressResolvingException)Assertions.assertThrows(AddressResolvingException.class, () -> DBusConnectionBuilder.forSessionBus().build());
            Assertions.assertEquals((Object)"No transports found to handle UNIX socket connections. Please add a unix-socket transport provider to your classpath", (Object)ex.getMessage());
        } else if (TransportBuilder.getRegisteredBusTypes().contains("UNIX")) {
            System.setProperty("DBUS_SESSION_BUS_ADDRESS", "tcp:host=INVALID");
            AddressResolvingException ex = (AddressResolvingException)Assertions.assertThrows(AddressResolvingException.class, () -> DBusConnectionBuilder.forSessionBus().build());
            Assertions.assertEquals((Object)"No transports found to handle TCP connections. Please add a TCP transport provider to your classpath", (Object)ex.getMessage());
        }
    }
}

