/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.SampleClass;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestShared
extends AbstractDBusBaseTest {
    public static final String TEST_OBJECT_PATH = "/TestAll";
    private DBusConnection serverconn = null;
    private DBusConnection clientconn = null;
    private SampleClass tclass;

    @BeforeEach
    public void setUp() throws DBusException {
        this.serverconn = ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withShared(true).withWeakReferences(true)).build();
        this.clientconn = ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withShared(true).withWeakReferences(true)).build();
        this.serverconn.requestBusName("foo.bar.Test");
        this.tclass = new SampleClass(this.serverconn);
        this.serverconn.exportObject(TEST_OBJECT_PATH, (DBusInterface)this.tclass);
        this.serverconn.addFallback("/FallbackTest", (DBusInterface)this.tclass);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.logger.debug("Checking for outstanding errors");
        DBusExecutionException dbee = this.serverconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        this.logger.debug("Disconnecting");
        this.clientconn.disconnect();
        this.serverconn.releaseBusName("foo.bar.Test");
        this.serverconn.disconnect();
    }

    @Test
    public void testGetThis() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        DBusInterface other = tri2.getThis(tri2);
        TestShared.assertEquals((Object)this.tclass, (Object)other, (String)"Didn't get the correct this");
    }
}

