/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper.twopart;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.test.helper.interfaces.TwoPartInterface;
import org.freedesktop.dbus.test.helper.interfaces.TwoPartObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPartTestServer
implements TwoPartInterface,
DBusSigHandler<TwoPartInterface.TwoPartSignal> {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DBusConnection conn;
    private long signalSerial;

    public TwoPartTestServer(DBusConnection _conn) {
        this.conn = _conn;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    @Override
    public TwoPartObject getNew() {
        TwoPartTestObject o = new TwoPartTestObject();
        this.logger.debug("export new");
        try {
            this.conn.exportObject("/12345", (DBusInterface)o);
        }
        catch (Exception _ex) {
            this.logger.debug("Caught exception: {}", (Object)_ex.getMessage());
        }
        this.logger.debug("give new");
        return o;
    }

    public void handle(TwoPartInterface.TwoPartSignal _s) {
        this.logger.debug("Got: " + _s.o);
        if (this.signalSerial != 0L) {
            this.logger.error("Serial already set!!!!");
        }
        this.signalSerial = _s.getSerial();
    }

    public long getSignalSerial() {
        return this.signalSerial;
    }

    public class TwoPartTestObject
    implements TwoPartObject {
        public boolean isRemote() {
            return false;
        }

        public String getObjectPath() {
            return null;
        }

        @Override
        public String getName() {
            return "give name";
        }

        public String toString() {
            return this.getClass().getName() + " [getName=" + this.getName() + "]";
        }
    }
}

