/*
 * Decompiled with CFR 0.152.
 */
package sample.issue;

import java.lang.reflect.Proxy;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

public class Issue196Test
extends AbstractBaseTest {
    @Test
    public void testCorrectInterfaceCreation() throws Exception {
        String protocolType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
        BusAddress busAddress = TransportBuilder.createWithDynamicSession((String)protocolType).configure().build().getBusAddress();
        BusAddress listenBusAddress = BusAddress.of((BusAddress)busAddress).getListenerAddress();
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(listenBusAddress);){
            daemon.startInBackground();
            this.logger.debug("Started embedded bus on address {}", (Object)listenBusAddress);
            Issue196Test.waitForDaemon(daemon);
            this.logger.info("Connecting to embedded DBus {}", (Object)busAddress);
            String source = "dbus.issue196";
            String path = "/dbus/issue196";
            try (DBusConnection connection = DBusConnectionBuilder.forAddress((BusAddress)busAddress).build();){
                DBusInterface dbi = null;
                RemoteInvocationHandler rih = null;
                connection.requestBusName("dbus.issue196");
                connection.exportObject("/dbus/issue196", (DBusInterface)new TestInterfaceType(){

                    public String getObjectPath() {
                        return "/dbus/issue196";
                    }
                });
                dbi = connection.dynamicProxy("dbus.issue196", "/dbus/issue196", null);
                Issue196Test.assertNotNull((Object)dbi);
                rih = (RemoteInvocationHandler)RemoteInvocationHandler.class.cast(Proxy.getInvocationHandler(dbi));
                Issue196Test.assertNotNull((Object)rih);
                RemoteObject ro = rih.getRemote();
                Issue196Test.assertNull((Object)ro.getInterface());
                Class<TestInterfaceType> type = TestInterfaceType.class;
                dbi = connection.dynamicProxy("dbus.issue196", "/dbus/issue196", type);
                Issue196Test.assertNotNull((Object)dbi);
                Issue196Test.assertTrue((boolean)TestInterfaceType.class.isInstance(dbi));
                rih = (RemoteInvocationHandler)RemoteInvocationHandler.class.cast(Proxy.getInvocationHandler(dbi));
                Issue196Test.assertNotNull((Object)rih);
                ro = rih.getRemote();
                Issue196Test.assertNotNull((Object)ro.getInterface());
                Issue196Test.assertSame(type, (Object)ro.getInterface());
            }
        }
    }

    @DBusInterfaceName(value="dbus.issue196.TestInterfaceType")
    public static interface TestInterfaceType
    extends DBusInterface {
    }
}

