/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.freedesktop.dbus.bin.DBusDaemon;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

public class EmbeddedDBusDaemonTest
extends AbstractBaseTest {
    @Test
    public void testStartAndConnectEmbeddedDBusDaemon() throws DBusException {
        String protocolType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
        String newAddress = TransportBuilder.createDynamicSession((String)protocolType, (boolean)false);
        BusAddress busAddress = BusAddress.of((String)newAddress);
        BusAddress listenBusAddress = BusAddress.of((String)(newAddress + ",listen=true"));
        this.logger.debug("Starting embedded bus on address {})", (Object)listenBusAddress);
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(listenBusAddress);){
            daemon.startInBackground();
            this.logger.debug("Started embedded bus on address {}", (Object)listenBusAddress);
            EmbeddedDBusDaemonTest.waitForDaemon(daemon);
            this.logger.info("Connecting to embedded DBus {}", (Object)busAddress);
            try (DBusConnection conn = DBusConnectionBuilder.forAddress((BusAddress)busAddress).build();){
                this.logger.debug("Connected to embedded DBus {}", (Object)busAddress);
            }
            catch (Exception _ex) {
                EmbeddedDBusDaemonTest.fail((String)"Connection to EmbeddedDbusDaemon failed", (Throwable)_ex);
                this.logger.error("Error connecting to EmbeddedDbusDaemon", (Throwable)_ex);
            }
        }
        catch (IOException _ex1) {
            EmbeddedDBusDaemonTest.fail((String)"Failed to start EmbeddedDbusDaemon", (Throwable)_ex1);
            this.logger.error("Error starting EmbeddedDbusDaemon", (Throwable)_ex1);
        }
    }

    @Test
    public void testStartStop() throws Exception {
        for (int i = 0; i < 2; ++i) {
            String address = TransportBuilder.createDynamicSession((String)((String)TransportBuilder.getRegisteredBusTypes().get(0)), (boolean)true);
            BusAddress busAddress = BusAddress.of((String)address);
            EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(busAddress);
            if (busAddress.isBusType("TCP")) {
                String addrStr = busAddress.removeParameter("listen").toString();
                System.setProperty("DBUS_SESSION_BUS_ADDRESS", addrStr);
            }
            AtomicReference exception = new AtomicReference();
            Thread daemonThread = new Thread(() -> {
                try {
                    daemon.startInForeground();
                }
                catch (Exception _ex) {
                    exception.set(_ex);
                    _ex.printStackTrace();
                }
            });
            daemonThread.start();
            Thread.sleep(1000L);
            daemon.close();
            EmbeddedDBusDaemonTest.assertEquals(null, exception.get());
        }
        long dbusDaemonThreadCnt = Thread.getAllStackTraces().keySet().stream().filter(e -> e.getName().startsWith(DBusDaemon.class.getSimpleName())).count();
        EmbeddedDBusDaemonTest.assertEquals((long)0L, (long)dbusDaemonThreadCnt, (String)"All dbus daemon threads should have been terminated");
    }
}

