/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDBusBaseTest
extends AbstractBaseTest {
    protected static EmbeddedDBusDaemon edbus;

    protected static void waitIfTcp() throws InterruptedException {
        if (!TransportBuilder.getRegisteredBusTypes().contains("UNIX")) {
            Thread.sleep(500L);
        }
    }

    @BeforeAll
    public static void beforeAll() throws DBusException, InterruptedException {
        Logger logger = LoggerFactory.getLogger(AbstractDBusBaseTest.class);
        if (!TransportBuilder.getRegisteredBusTypes().contains("UNIX")) {
            String busType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
            String addr = TransportBuilder.createDynamicSession((String)busType, (boolean)true);
            BusAddress address = BusAddress.of((String)addr);
            logger.info("Creating {} based DBus daemon on address {}", (Object)busType, (Object)addr);
            edbus = new EmbeddedDBusDaemon(addr);
            edbus.startInBackground();
            if (address.isBusType("TCP")) {
                String addrStr = address.removeParameter("listen").toString();
                System.setProperty("DBUS_SESSION_BUS_ADDRESS", addrStr);
            }
            AbstractDBusBaseTest.waitForDaemon(edbus);
        }
    }

    @AfterAll
    public static void afterAll() throws IOException {
        if (edbus != null) {
            edbus.close();
        }
    }
}

