/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExportedObjectTest {
    @Test
    void testNoInterface() throws DBusException {
        ExportedObject exportedObject = new ExportedObject((DBusInterface)new NoInterface(), false);
        this.checkIntrospectionData(exportedObject.getIntrospectiondata());
    }

    @Test
    void testMultiInterface() throws DBusException {
        ExportedObject exportedObject = new ExportedObject((DBusInterface)new MultiInterface(), false);
        this.checkIntrospectionData(exportedObject.getIntrospectiondata());
    }

    @Test
    void testOneInterface() throws DBusException {
        ExportedObject exportedObject = new ExportedObject((DBusInterface)new OneInterface(), false);
        this.checkIntrospectionData(exportedObject.getIntrospectiondata());
    }

    @Test
    void testIndirectInterface() throws DBusException {
        ExportedObject exportedObject = new ExportedObject((DBusInterface)new IndirectInterface(), false);
        this.checkIntrospectionData(exportedObject.getIntrospectiondata());
    }

    private void checkIntrospectionData(String _introspectiondata) {
        if (_introspectiondata == null || _introspectiondata.isBlank()) {
            Assertions.fail((String)"Empty/null introspection data");
        }
        Pattern ifNamePattern = Pattern.compile("<interface.+name=\"([^\"]+)\".+");
        Pattern mthNamePattern = Pattern.compile("<method.+name=\"([^\"]+)\".+");
        LinkedHashMap interfacesAndMethods = new LinkedHashMap();
        String ifName = null;
        for (String line : _introspectiondata.split("\n")) {
            if ((line = line.trim()).contains("</interface>")) {
                ifName = null;
            }
            if (line.contains("<interface ")) {
                Matcher ifMatcher = ifNamePattern.matcher(line);
                ifMatcher.find();
                ifName = ifMatcher.group(1);
                if (!interfacesAndMethods.containsKey(ifName)) {
                    interfacesAndMethods.put(ifName, new ArrayList());
                } else {
                    Assertions.fail((String)("Duplicated exported interface: " + ifName));
                }
            }
            if (ifName == null || !line.contains("<method ")) continue;
            Matcher mthMatcher = mthNamePattern.matcher(line);
            mthMatcher.find();
            String mthName = mthMatcher.group(1);
            if (((List)interfacesAndMethods.get(ifName)).contains(mthName)) {
                Assertions.fail((String)("Duplicated method in interface: " + ifName));
            }
            ((List)interfacesAndMethods.get(ifName)).add(mthName);
        }
    }

    public static class NoInterface
    implements DBusInterface {
        public void why() {
        }

        public String getObjectPath() {
            return "/test";
        }
    }

    public static class MultiInterface
    implements BarFace,
    FooFace {
        public String getObjectPath() {
            return "/foobar";
        }

        @Override
        public void foo() {
        }

        @Override
        public void bar() {
        }

        public <A> A Get(String _interfaceName, String _propertyName) {
            return null;
        }

        public <A> void Set(String _interfaceName, String _propertyName, A _value) {
        }

        public Map<String, Variant<?>> GetAll(String _interfaceName) {
            return null;
        }
    }

    public static class OneInterface
    implements DBusInterface,
    Properties {
        public String getObjectPath() {
            return "/test";
        }

        public <A> A Get(String _interfaceName, String _propertyName) {
            return null;
        }

        public <A> void Set(String _interfaceName, String _propertyName, A _value) {
        }

        public Map<String, Variant<?>> GetAll(String _interfaceName) {
            return null;
        }
    }

    public static class IndirectInterface
    implements Properties {
        public String getObjectPath() {
            return null;
        }

        public <A> A Get(String _interfaceName, String _propertyName) {
            return null;
        }

        public <A> void Set(String _interfaceName, String _propertyName, A _value) {
        }

        public Map<String, Variant<?>> GetAll(String _interfaceName) {
            return null;
        }
    }

    public static interface FooFace
    extends DBusInterface,
    Properties {
        public void foo();
    }

    public static interface BarFace
    extends DBusInterface,
    Properties {
        public void bar();
    }
}

