/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.text.ParseException;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.utils.AddressBuilder;
import org.junit.jupiter.api.Test;

public class LowLevelTest
extends AbstractDBusBaseTest {
    @Test
    public void testLowLevel() throws ParseException, IOException, DBusException, InterruptedException {
        BusAddress address = BusAddress.of((BusAddress)AddressBuilder.getSessionConnection(null));
        this.logger.debug("Testing using address: {}", (Object)address);
        try (AbstractTransport conn = TransportBuilder.create((BusAddress)address).build();){
            LowLevelTest.waitIfTcp();
            MethodCall m = new MethodCall("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "Hello", 0, null, new Object[0]);
            conn.writeMessage((Message)m);
            LowLevelTest.waitIfTcp();
            m = conn.readMessage();
            this.logger.debug(String.valueOf(m.getClass()));
            this.logger.debug(String.valueOf(m));
            m = conn.readMessage();
            this.logger.debug(String.valueOf(m.getClass()));
            this.logger.debug(String.valueOf(m));
            m = new MethodCall("org.freedesktop.DBus", "/", null, "Hello", 0, null, new Object[0]);
            conn.writeMessage((Message)m);
            LowLevelTest.waitIfTcp();
            m = conn.readMessage();
            this.logger.debug(String.valueOf(m));
            m = new MethodCall("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", 0, "su", new Object[]{"org.testname", 0});
            conn.writeMessage((Message)m);
            LowLevelTest.waitIfTcp();
            m = conn.readMessage();
            this.logger.debug(String.valueOf(m));
            m = new DBusSignal(null, "/foo", "org.foo", "Foo", null, new Object[0]);
            conn.writeMessage((Message)m);
            LowLevelTest.waitIfTcp();
            m = conn.readMessage();
            this.logger.debug(String.valueOf(m));
        }
    }
}

