/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class SignalNameTest
extends AbstractBaseTest {
    @Test
    public void testSignalNameAlias() throws Exception {
        String protocolType = (String)TransportBuilder.getRegisteredBusTypes().get(0);
        BusAddress busAddress = TransportBuilder.createWithDynamicSession((String)protocolType).configure().build().getBusAddress();
        BusAddress listenBusAddress = BusAddress.of((BusAddress)busAddress).getListenerAddress();
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon(listenBusAddress);){
            daemon.startInBackground();
            this.logger.debug("Started embedded bus on address {}", (Object)listenBusAddress);
            SignalNameTest.waitForDaemon(daemon);
            this.logger.info("Connecting to embedded DBus {}", (Object)busAddress);
            try (DBusConnection connection = DBusConnectionBuilder.forAddress((BusAddress)busAddress).build();){
                connection.requestBusName("d.e.f.Service");
                connection.exportObject("/d/e/f/custom", (DBusInterface)new MyCustomImpl());
                connection.addSigHandler(CustomService.CustomSignal.class, (DBusSigHandler)new DBusSigHandler<CustomService.CustomSignal>(){

                    public void handle(CustomService.CustomSignal _s) {
                        SignalNameTest.this.logger.debug("Received signal: {}", (Object)_s.data);
                    }
                });
                connection.sendMessage((Message)new CustomService.CustomSignal("/a/b/c/custom", "hello world"));
                Thread.sleep(1000L);
            }
        }
    }

    public static class MyCustomImpl
    implements CustomService {
        @Override
        public void nothing() {
            LoggerFactory.getLogger(this.getClass()).debug("Just doing nothing");
        }

        public String getObjectPath() {
            return "/d/e/f/custom";
        }
    }

    @DBusInterfaceName(value="d.e.f.Custom")
    public static interface CustomService
    extends DBusInterface {
        public void nothing();

        @DBusMemberName(value="custom_signal")
        public static class CustomSignal
        extends DBusSignal {
            public final String data;

            public CustomSignal(String _path, String _data) throws DBusException {
                super(_path, new Object[]{_data});
                this.data = _data;
            }
        }
    }
}

