/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class StressTest
extends AbstractDBusBaseTest {
    private static final String OBJECT_PATH = "/org/freedesktop/dbus/test/RemoteObjectImpl";
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    private final Random random = new Random();
    private final Map<String, AtomicInteger> clientCalls = new HashMap<String, AtomicInteger>();
    private final List<Throwable> asyncExceptions = new CopyOnWriteArrayList<Throwable>();

    @AfterEach
    public void tearDown() throws Exception {
        Collections.reverse(this.closeables);
        this.closeables.forEach(closeable -> StressTest.runUnchecked(() -> closeable.close()));
    }

    @Test
    public void test() throws Exception {
        int numberOfServices = 10;
        int numberOfClients = 10;
        int numberOfRequestsPerClient = 100;
        List<DBusConnection> serviceConnections = this.createServices(numberOfServices);
        List<DBusConnection> clientConnections = this.createClientConnections(numberOfClients);
        List<Thread> threads = this.createClientThreads(clientConnections, serviceConnections, numberOfRequestsPerClient);
        threads.forEach(Thread::start);
        threads.forEach(t -> StressTest.runUnchecked(() -> t.join(10000L)));
        StressTest.assertTrue((boolean)this.asyncExceptions.isEmpty(), (String)"No exceptions expected");
        StressTest.assertEquals((int)numberOfClients, (int)this.clientCalls.size());
        for (DBusConnection clientConnection : clientConnections) {
            AtomicInteger counter = this.clientCalls.get(clientConnection.getUniqueName());
            StressTest.assertNotNull((Object)counter);
            StressTest.assertEquals((int)numberOfRequestsPerClient, (int)counter.get());
        }
    }

    private List<Thread> createClientThreads(List<DBusConnection> _clientConnections, List<DBusConnection> _serviceConnections, int _numberOfRequestsPerClient) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (DBusConnection clientConnection : _clientConnections) {
            Thread thread = new Thread(() -> this.stressServices(clientConnection, _serviceConnections, _numberOfRequestsPerClient));
            thread.setName("ClientThread-" + clientConnection.getUniqueName());
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t, e) -> this.asyncExceptions.add(e));
            threads.add(thread);
        }
        return threads;
    }

    private List<DBusConnection> createClientConnections(int _numberOfClients) throws DBusException {
        ArrayList<DBusConnection> clientConnections = new ArrayList<DBusConnection>(_numberOfClients);
        for (int i = 0; i < _numberOfClients; ++i) {
            clientConnections.add(DBusConnectionBuilder.forSessionBus().withShared(false).build());
        }
        return clientConnections;
    }

    private List<DBusConnection> createServices(int _numberOfServices) throws DBusException {
        ArrayList<DBusConnection> serviceConnections = new ArrayList<DBusConnection>();
        for (int i = 0; i < _numberOfServices; ++i) {
            RemoteObjectImpl service = new RemoteObjectImpl();
            DBusConnection serviceConnection = DBusConnectionBuilder.forSessionBus().withShared(false).build();
            this.closeables.add((Closeable)serviceConnection);
            serviceConnections.add(serviceConnection);
            serviceConnection.exportObject(OBJECT_PATH, (DBusInterface)service);
        }
        return serviceConnections;
    }

    private void stressServices(DBusConnection _client, List<DBusConnection> _serviceConnections, int _requestCount) {
        ArrayList services = new ArrayList();
        _serviceConnections.forEach(connection -> StressTest.runUnchecked(() -> {
            RemoteObject service = (RemoteObject)_client.getRemoteObject(connection.getUniqueName(), OBJECT_PATH, RemoteObject.class);
            services.add(service);
        }));
        for (int i = 0; i < _requestCount; ++i) {
            int serviceIdx = this.random.nextInt(services.size());
            ((RemoteObject)services.get(serviceIdx)).doSomething(_client.getUniqueName());
        }
    }

    private static void runUnchecked(ThrowingRunnable _runnable) {
        try {
            _runnable.run();
        }
        catch (Error | RuntimeException _ex) {
            throw _ex;
        }
        catch (Throwable _ex) {
            throw new RuntimeException(_ex);
        }
    }

    public class RemoteObjectImpl
    implements RemoteObject {
        public boolean isRemote() {
            return false;
        }

        public String getObjectPath() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doSomething(String _clientName) {
            AtomicInteger counter;
            Map<String, AtomicInteger> map = StressTest.this.clientCalls;
            synchronized (map) {
                counter = StressTest.this.clientCalls.get(_clientName);
                if (counter == null) {
                    counter = new AtomicInteger(0);
                    StressTest.this.clientCalls.put(_clientName, counter);
                }
            }
            counter.incrementAndGet();
        }
    }

    public static interface RemoteObject
    extends DBusInterface {
        public void doSomething(String var1);
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

