/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.Type;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.errors.ServiceUnknown;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractDBusBaseTest;
import org.freedesktop.dbus.test.helper.SampleClass;
import org.freedesktop.dbus.test.helper.SampleException;
import org.freedesktop.dbus.test.helper.SampleNewInterfaceClass;
import org.freedesktop.dbus.test.helper.SampleSerializable;
import org.freedesktop.dbus.test.helper.callbacks.handler.CallbackHandlerImpl;
import org.freedesktop.dbus.test.helper.interfaces.SampleNewInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterfaceEnum;
import org.freedesktop.dbus.test.helper.signals.SampleSignals;
import org.freedesktop.dbus.test.helper.signals.handler.ArraySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.BadArraySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.EmptySignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.EnumSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.GenericHandlerWithDecode;
import org.freedesktop.dbus.test.helper.signals.handler.GenericSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.ObjectSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.PathSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.RenamedSignalHandler;
import org.freedesktop.dbus.test.helper.signals.handler.SignalHandler;
import org.freedesktop.dbus.test.helper.structs.IntStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct2;
import org.freedesktop.dbus.test.helper.structs.SampleStruct3;
import org.freedesktop.dbus.test.helper.structs.SampleStruct4;
import org.freedesktop.dbus.test.helper.structs.SampleTuple;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.TimeMeasure;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAll
extends AbstractDBusBaseTest {
    public static final String TEST_OBJECT_PATH = "/TestAll";
    private DBusConnection serverconn = null;
    private DBusConnection clientconn = null;
    private SampleClass tclass;

    @BeforeEach
    public void setUp() throws DBusException {
        this.serverconn = ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withShared(false).withWeakReferences(true)).build();
        this.clientconn = ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withShared(false).withWeakReferences(true)).build();
        this.serverconn.requestBusName("foo.bar.Test");
        this.tclass = new SampleClass(this.serverconn);
        this.serverconn.exportObject(TEST_OBJECT_PATH, (DBusInterface)this.tclass);
        this.serverconn.addFallback("/FallbackTest", (DBusInterface)this.tclass);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.logger.debug("Checking for outstanding errors");
        DBusExecutionException dbee = this.serverconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        dbee = this.clientconn.getError();
        if (null != dbee) {
            throw dbee;
        }
        this.logger.debug("Disconnecting");
        this.clientconn.disconnect();
        this.serverconn.releaseBusName("foo.bar.Test");
        this.serverconn.disconnect();
    }

    @Test
    public void testSignalHandlers() throws DBusException, InterruptedException {
        SignalHandler sigh = new SignalHandler(1, new UInt32(42L), "Bar");
        RenamedSignalHandler rsh = new RenamedSignalHandler(1, new UInt32(42L), "Bar");
        EmptySignalHandler esh = new EmptySignalHandler(1);
        ArraySignalHandler ash = new ArraySignalHandler(1);
        ObjectSignalHandler osh = new ObjectSignalHandler(1);
        PathSignalHandler psh = new PathSignalHandler(1);
        EnumSignalHandler ensh = new EnumSignalHandler(1);
        SampleRemoteInterface peer = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        DBus dbus = (DBus)this.clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        this.logger.debug("Listening for signals...");
        this.clientconn.addSigHandler(SampleSignals.TestEmptySignal.class, (DBusSigHandler)esh);
        this.clientconn.addSigHandler(SampleSignals.TestSignal.class, (DBusSigHandler)sigh);
        this.clientconn.addSigHandler(SampleSignals.TestRenamedSignal.class, (DBusSigHandler)rsh);
        String source = dbus.GetNameOwner("foo.bar.Test");
        this.clientconn.addSigHandler(SampleSignals.TestArraySignal.class, source, (DBusInterface)peer, (DBusSigHandler)ash);
        this.clientconn.addSigHandler(SampleSignals.TestObjectSignal.class, (DBusSigHandler)osh);
        this.clientconn.addSigHandler(SampleSignals.TestPathSignal.class, (DBusSigHandler)psh);
        this.clientconn.addSigHandler(SampleSignals.TestEnumSignal.class, (DBusSigHandler)ensh);
        BadArraySignalHandler bash = new BadArraySignalHandler(1);
        this.clientconn.addSigHandler(SampleSignals.TestSignal.class, bash);
        this.clientconn.removeSigHandler(SampleSignals.TestSignal.class, bash);
        this.logger.debug("done");
        this.logger.debug("Sending Signals");
        this.serverconn.sendMessage((Message)new SampleSignals.TestSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
        this.serverconn.sendMessage((Message)new SampleSignals.TestEmptySignal("/foo/bar/Wibble"));
        this.serverconn.sendMessage((Message)new SampleSignals.TestRenamedSignal("/foo/bar/Wibble", "Bar", new UInt32(42L)));
        this.logger.debug("Sending Path Signal...");
        DBusPath path = new DBusPath("/nonexistantwooooooo");
        DBusPath p = peer.pathrv(path);
        this.logger.debug(path.toString() + " => " + p.toString());
        TestAll.assertEquals((Object)path, (Object)p, (String)"pathrv incorrect");
        ArrayList<DBusPath> paths = new ArrayList<DBusPath>();
        paths.add(path);
        List<DBusPath> ps = peer.pathlistrv(paths);
        this.logger.debug(((Object)paths).toString() + " => " + ps.toString());
        HashMap<DBusPath, DBusPath> pathm = new HashMap<DBusPath, DBusPath>();
        pathm.put(path, path);
        this.serverconn.sendMessage((Message)new SampleSignals.TestPathSignal(TEST_OBJECT_PATH, path, paths, pathm));
        this.logger.debug("Sending Array Signal...");
        ArrayList<SampleStruct2> tsl = new ArrayList<SampleStruct2>();
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("hello");
        l.add("hej");
        l.add("hey");
        l.add("aloha");
        tsl.add(new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(567L))));
        HashMap<UInt32, SampleStruct2> tsm = new HashMap<UInt32, SampleStruct2>();
        tsm.put(new UInt32(1L), new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(678L))));
        tsm.put(new UInt32(42L), new SampleStruct2(l, (Variant<? extends Object>)new Variant((Object)new UInt64(789L))));
        this.serverconn.sendMessage((Message)new SampleSignals.TestArraySignal(TEST_OBJECT_PATH, tsl, tsm));
        this.logger.debug("Sending Object Signal...");
        this.serverconn.sendMessage((Message)new SampleSignals.TestObjectSignal(TEST_OBJECT_PATH, this.tclass));
        this.logger.debug("Sending Enum Signal...");
        this.serverconn.sendMessage((Message)new SampleSignals.TestEnumSignal(TEST_OBJECT_PATH, SampleRemoteInterfaceEnum.TestEnum.TESTVAL1, Arrays.asList(SampleRemoteInterfaceEnum.TestEnum.TESTVAL2, SampleRemoteInterfaceEnum.TestEnum.TESTVAL3)));
        Thread.sleep(1000L);
        TestAll.assertTrue((sigh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"SignalHandler should have been called");
        TestAll.assertTrue((esh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"EmptySignalHandler should have been called");
        TestAll.assertTrue((rsh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"RenamedSignalHandler should have been called");
        TestAll.assertTrue((ash.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"ArraySignalHandler should have been called");
        TestAll.assertTrue((ensh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"EnumSignalHandler should have been called");
        TestAll.assertTrue((psh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"PathSignalHandler should have been called");
        TestAll.assertTrue((osh.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"ObjectSignalHandler should have been called");
        TestAll.assertDoesNotThrow(() -> sigh.throwAssertionError());
        TestAll.assertDoesNotThrow(() -> esh.throwAssertionError());
        TestAll.assertDoesNotThrow(() -> rsh.throwAssertionError());
        TestAll.assertDoesNotThrow(() -> ash.throwAssertionError());
        TestAll.assertDoesNotThrow(() -> ensh.throwAssertionError());
        TestAll.assertDoesNotThrow(() -> psh.throwAssertionError());
        TestAll.assertDoesNotThrow(() -> osh.throwAssertionError());
        this.clientconn.removeSigHandler(SampleSignals.TestSignal.class, (DBusSigHandler)sigh);
        this.clientconn.removeSigHandler(SampleSignals.TestEmptySignal.class, (DBusSigHandler)esh);
        this.clientconn.removeSigHandler(SampleSignals.TestRenamedSignal.class, (DBusSigHandler)rsh);
        this.clientconn.removeSigHandler(SampleSignals.TestArraySignal.class, (DBusSigHandler)ash);
        this.clientconn.removeSigHandler(SampleSignals.TestObjectSignal.class, (DBusSigHandler)osh);
        this.clientconn.removeSigHandler(SampleSignals.TestPathSignal.class, (DBusSigHandler)psh);
        this.clientconn.removeSigHandler(SampleSignals.TestEnumSignal.class, (DBusSigHandler)ensh);
    }

    @Test
    public void testGenericSignalHandler() throws DBusException, InterruptedException {
        GenericSignalHandler genericHandler = new GenericSignalHandler();
        DBusMatchRule signalRule = new DBusMatchRule("signal", "org.foo", "methodnoarg", "/");
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericHandler);
        DBusSignal signalToSend = new DBusSignal(null, "/", "org.foo", "methodnoarg", null, new Object[0]);
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        TestAll.assertTrue((genericHandler.getActualTestRuns() == 1 ? 1 : 0) != 0, (String)"GenericHandler should have been called");
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericHandler);
    }

    @Test
    public void testGenericDecodeSignalHandler() throws DBusException, InterruptedException {
        GenericHandlerWithDecode genericDecode = new GenericHandlerWithDecode(new UInt32(42L), "SampleString");
        DBusMatchRule signalRule = new DBusMatchRule("signal", "org.foo", "methodarg", "/");
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        DBusSignal signalToSend = new DBusSignal(null, "/", "org.foo", "methodarg", "us", new Object[]{new UInt32(42L), "SampleString"});
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        genericDecode.incomingSameAsExpected();
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
    }

    @Test
    public void testGenericHandlerWithNoInterface() throws DBusException, InterruptedException {
        GenericHandlerWithDecode genericDecode = new GenericHandlerWithDecode(new UInt32(42L), "SampleString");
        DBusMatchRule signalRule = new DBusMatchRule("signal", null, "methodargNoIface", "/");
        this.clientconn.addGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
        DBusSignal signalToSend = new DBusSignal(null, "/", "org.foo", "methodargNoIface", "us", new Object[]{new UInt32(42L), "SampleString"});
        this.serverconn.sendMessage((Message)signalToSend);
        Thread.sleep(1000L);
        genericDecode.incomingSameAsExpected();
        this.clientconn.removeGenericSigHandler(signalRule, (DBusSigHandler)genericDecode);
    }

    @Test
    public void testPing() throws DBusException {
        this.logger.debug("Pinging ourselves");
        Peer peer = (Peer)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Peer.class);
        TimeMeasure timeMeasure = new TimeMeasure();
        for (int i = 0; i < 10; ++i) {
            timeMeasure.reset();
            peer.Ping();
            this.logger.debug("Ping returned in " + timeMeasure.getElapsed() + "ms.");
        }
    }

    public void testDbusNames() throws DBusException {
        this.logger.debug("These things are on the bus:");
        this.logger.debug("Listening for Method Calls");
        SampleClass mtclass = new SampleClass(this.serverconn);
        SampleClass tclass2 = new SampleClass(this.serverconn);
        this.serverconn.exportObject("/TestClassToFindOnBus", (DBusInterface)mtclass);
        this.serverconn.exportObject("/SecondTestClassToFindOnBus", (DBusInterface)tclass2);
        DBus dbus = (DBus)this.clientconn.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        String[] names = dbus.ListNames();
        TestAll.assertTrue((boolean)Arrays.asList(names).contains("/TestClassToFindOnBus"));
        TestAll.assertTrue((boolean)Arrays.asList(names).contains("/SecondTestClassToFindOnBus"));
        this.serverconn.unExportObject("/SecondTestClassToFindOnBus");
        this.serverconn.unExportObject("/TestClassToFindOnBus");
    }

    @Test
    public void testIntrospection() throws DBusException {
        this.logger.debug("Getting our introspection data");
        Introspectable intro = (Introspectable)this.clientconn.getRemoteObject("foo.bar.Test", "/", Introspectable.class);
        intro = (Introspectable)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Introspectable.class);
        String data = intro.Introspect();
        TestAll.assertNotNull((Object)data);
        TestAll.assertTrue((boolean)data.startsWith("<!DOCTYPE"));
    }

    @Test
    public void testCallRemoteMethod() throws DBusException {
        this.logger.debug("Calling Method0/1");
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        this.logger.debug("Got Remote Object: " + String.valueOf(tri));
        String rname = tri.getName();
        this.logger.debug("Got Remote Name: " + rname);
        ArrayList ts = new ArrayList();
        Marshalling.getJavaType((String)"ya{si}", ts, (int)-1);
        tri.sig(ts.toArray(new Type[0]));
        DBusPath path = new DBusPath("/nonexistantwooooooo");
        DBusPath p = tri.pathrv(path);
        this.logger.debug(path.toString() + " => " + p.toString());
        TestAll.assertEquals((Object)path, (Object)p, (String)"pathrv incorrect");
        ArrayList<DBusPath> paths = new ArrayList<DBusPath>();
        paths.add(path);
        List<DBusPath> ps = tri.pathlistrv(paths);
        this.logger.debug(((Object)paths).toString() + " => " + ps.toString());
        TestAll.assertEquals(paths, ps, (String)"pathlistrv incorrect");
        HashMap<DBusPath, DBusPath> pathm = new HashMap<DBusPath, DBusPath>();
        pathm.put(path, path);
        Map<DBusPath, DBusPath> pm = tri.pathmaprv(pathm);
        this.logger.debug(((Object)pathm).toString() + " => " + pm.toString());
        this.logger.debug(pm.containsKey(path) + " " + String.valueOf(pm.get(path)) + " " + path.equals((Object)pm.get(path)));
        this.logger.debug(pm.containsKey(p) + " " + String.valueOf(pm.get(p)) + " " + p.equals((Object)pm.get(p)));
        TestAll.assertTrue((boolean)pm.containsKey(path), (String)"pathmaprv incorrect");
        TestAll.assertTrue((boolean)path.equals((Object)pm.get(path)), (String)"pathmaprv incorrect");
    }

    @Test
    public void testCallGetUtf8String() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        String rname = tri.getName();
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", rname)) {
            TestAll.fail((String)"getName return value incorrect");
        }
    }

    @Test
    public void testFloats() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        this.logger.debug("sending it to sleep");
        tri.waitawhile();
        this.logger.debug("testing floats");
        if (17.093f != tri.testfloat(new float[]{17.093f, -23.0f, 0.0f, 31.42f})) {
            TestAll.fail((String)"testfloat returned the wrong thing");
        }
    }

    @Test
    public void testStruct() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        ArrayList<List<Integer>> lli = new ArrayList<List<Integer>>();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(1);
        li.add(2);
        li.add(3);
        lli.add(li);
        lli.add(li);
        lli.add(li);
        SampleStruct3 ts3 = new SampleStruct3(new SampleStruct2(new ArrayList<String>(), (Variant<? extends Object>)new Variant((Object)0)), lli);
        int[][] out = tri.teststructstruct(ts3);
        if (out.length != 3) {
            TestAll.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
        for (int[] o : out) {
            if (o.length == 3 && o[0] == 1 && o[1] == 2 && o[2] == 3) continue;
            TestAll.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
    }

    @Test
    public void testListOfStruct() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        IntStruct elem1 = new IntStruct(3, 7);
        IntStruct elem2 = new IntStruct(9, 14);
        List<IntStruct> list = Arrays.asList(elem1, elem2);
        SampleStruct4 param = new SampleStruct4(list);
        int[][] out = tri.testListstruct(param);
        if (out.length != 2) {
            TestAll.fail((String)("teststructstruct returned the wrong thing: " + Arrays.deepToString((Object[])out)));
        }
        TestAll.assertEquals((int)elem1.getValue1(), (int)out[0][0]);
        TestAll.assertEquals((int)elem1.getValue2(), (int)out[0][1]);
        TestAll.assertEquals((int)elem2.getValue1(), (int)out[1][0]);
        TestAll.assertEquals((int)elem2.getValue2(), (int)out[1][1]);
    }

    @Test
    public void testEnum() throws DBusException {
        SampleRemoteInterfaceEnum tri = (SampleRemoteInterfaceEnum)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        TestAll.assertEquals((Object)((Object)SampleRemoteInterfaceEnum.TestEnum.TESTVAL2), (Object)((Object)tri.getEnumValue()));
    }

    @Test
    public void testDbusIgnore() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        TestAll.assertThrowsExactly(UnknownMethod.class, () -> tri.thisShouldBeIgnored());
    }

    public void testFrob() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        this.logger.debug("frobnicating");
        ArrayList<Long> ls = new ArrayList<Long>();
        ls.add(2L);
        ls.add(5L);
        ls.add(71L);
        HashMap<UInt16, Short> mus = new HashMap<UInt16, Short>();
        mus.put(new UInt16(4), (short)5);
        mus.put(new UInt16(5), (short)6);
        mus.put(new UInt16(6), (short)7);
        HashMap<String, Map<UInt16, Short>> msmus = new HashMap<String, Map<UInt16, Short>>();
        msmus.put("stuff", mus);
        int rint = tri.frobnicate(ls, msmus, 13);
        if (-5 != rint) {
            TestAll.fail((String)"frobnicate return value incorrect");
        }
    }

    @Test
    public void testCallWithCallback() throws DBusException, InterruptedException {
        CallbackHandlerImpl cbWhichThrows;
        CallbackHandlerImpl cbWhichWorks;
        block2: {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
            this.logger.debug("Doing stuff asynchronously with callback");
            cbWhichWorks = new CallbackHandlerImpl();
            this.clientconn.callWithCallback((DBusInterface)tri, "getName", (CallbackHandler)cbWhichWorks, new Object[0]);
            this.logger.debug("Doing stuff asynchronously with callback, which throws an error");
            cbWhichThrows = new CallbackHandlerImpl();
            this.clientconn.callWithCallback((DBusInterface)tri, "getNameAndThrow", (CallbackHandler)cbWhichThrows, new Object[0]);
            try {
                this.logger.debug("Throwing stuff");
                tri.throwme();
                TestAll.fail((String)"Method Execution should have failed");
            }
            catch (SampleException _ex) {
                this.logger.debug("Remote Method Failed with: " + ((Object)((Object)_ex)).getClass().getName() + " " + _ex.getMessage());
                if (_ex.getMessage().equals("test")) break block2;
                TestAll.fail((String)"Error message was not correct");
            }
        }
        Thread.sleep(500L);
        TestAll.assertNull((Object)cbWhichThrows.getLastError());
        TestAll.assertNull((Object)cbWhichWorks.getLastError());
        TestAll.assertEquals((int)1, (int)cbWhichWorks.getTestHandleCalls());
        TestAll.assertEquals((int)0, (int)cbWhichThrows.getTestHandleCalls());
        TestAll.assertEquals((int)0, (int)cbWhichWorks.getTestErrorCalls());
        TestAll.assertEquals((int)1, (int)cbWhichThrows.getTestErrorCalls());
    }

    @Test
    public void testException() throws DBusException {
        block2: {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
            try {
                this.logger.debug("Throwing stuff");
                tri.throwme();
                TestAll.fail((String)"Method Execution should have failed");
            }
            catch (SampleException _ex) {
                this.logger.debug("Remote Method Failed with: " + ((Object)((Object)_ex)).getClass().getName() + " " + _ex.getMessage());
                if (_ex.getMessage().equals("test")) break block2;
                TestAll.fail((String)"Error message was not correct");
            }
        }
    }

    @Test
    public void testFails() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getPeerRemoteObject("foo.bar.Test", TEST_OBJECT_PATH);
        try {
            this.logger.debug("Calling Method2");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.NotATest", "/Moofle", SampleRemoteInterface.class);
            this.logger.debug("Got Remote Name: " + tri.getName());
            TestAll.fail((String)"Method Execution should have failed");
        }
        catch (ServiceUnknown _ex) {
            this.logger.debug("Remote Method Failed with: " + ((Object)((Object)_ex)).getClass().getName() + " " + _ex.getMessage());
        }
        try {
            this.logger.debug("Calling Method3");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", "/Moofle", SampleRemoteInterface.class);
            this.logger.debug("Got Remote Name: " + tri.getName());
            TestAll.fail((String)"Method Execution should have failed");
        }
        catch (UnknownObject _ex) {
            this.logger.debug("Remote Method Failed with: " + ((Object)((Object)_ex)).getClass().getName() + " " + _ex.getMessage());
        }
        try {
            this.logger.debug("Calling Method4");
            tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", "/BadTest", SampleRemoteInterface.class);
            this.logger.debug("Got Remote Name: " + tri.getName());
            TestAll.fail((String)"Method Execution should have failed");
        }
        catch (UnknownObject _ex) {
            this.logger.debug("Remote Method Failed with: " + ((Object)((Object)_ex)).getClass().getName() + " " + _ex.getMessage());
        }
    }

    @Test
    public void testFallback() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/1", SampleRemoteInterface.class);
        Introspectable intro = (Introspectable)this.clientconn.getRemoteObject("foo.bar.Test", "/FallbackTest/0/4", Introspectable.class);
        TestAll.assertEquals((Object)"This Is A UTF-8 Name: \u0633 !!", (Object)tri.getName());
        TestAll.assertTrue((boolean)intro.Introspect().startsWith("<!DOCTYPE"));
    }

    @Test
    public void testGetProperties() throws DBusException {
        Properties prop = (Properties)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, Properties.class);
        DBusPath prv = (DBusPath)prop.Get("foo.bar", "foo");
        this.logger.debug("Got path " + String.valueOf(prv));
        TestAll.assertEquals((Object)prv.getPath(), (Object)"/nonexistant/path");
    }

    @Test
    public void testExportPath() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        this.logger.debug("Calling the other introspect method: ");
        String intro2 = tri2.Introspect();
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        if (0 != col.compare("Not XML", intro2)) {
            TestAll.fail((String)"Introspect return value incorrect");
        }
    }

    @Test
    public void testResponse() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        this.logger.debug(tri2.Introspect());
        SampleTuple<String, List<Integer>, Boolean> rv = tri2.show(234);
        this.logger.debug("Show returned: " + String.valueOf(rv));
        if (!this.clientconn.getUniqueName().equals(rv.getFirstValue()) || 1 != rv.getSecondValue().size() || 1953 != rv.getSecondValue().get(0) || !rv.getThirdValue().booleanValue()) {
            TestAll.fail((String)("show return value incorrect (" + rv.getFirstValue() + "," + String.valueOf(rv.getSecondValue()) + "," + String.valueOf(rv.getThirdValue()) + ")"));
        }
        this.logger.debug("Doing stuff asynchronously");
        DBusAsyncReply stuffreply = this.clientconn.callMethodAsync((DBusInterface)tri2, "dostuff", new Object[]{new SampleStruct("bar", new UInt32(52L), new Variant((Object)Boolean.TRUE))});
        Thread.sleep(500L);
        TestAll.assertFalse((boolean)tri2.check(), (String)"bools are broken");
        TestAll.assertTrue((boolean)((Boolean)stuffreply.getReply()), (String)"dostuff return value incorrect");
    }

    @Test
    public void testArrays() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList<String> l = new ArrayList<String>();
        l.add("hi");
        l.add("hello");
        l.add("hej");
        l.add("hey");
        l.add("aloha");
        this.logger.debug("Sampling Arrays:");
        List<Integer> is = tri2.sampleArray(l, new Integer[]{1, 5, 7, 9}, new long[]{2L, 6L, 8L, 12L});
        this.logger.debug("sampleArray returned an array:");
        for (Integer i : is) {
            this.logger.debug("--" + i);
        }
        TestAll.assertEquals((int)5, (int)is.size());
        TestAll.assertEquals((int)-1, (int)is.get(0));
        TestAll.assertEquals((int)-5, (int)is.get(1));
        TestAll.assertEquals((int)-7, (int)is.get(2));
        TestAll.assertEquals((int)-12, (int)is.get(3));
        TestAll.assertEquals((int)-18, (int)is.get(4));
    }

    public void testSerialization() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList<Integer> v = new ArrayList<Integer>();
        v.add(1);
        v.add(2);
        v.add(3);
        SampleSerializable<String> s = new SampleSerializable<String>(1, "woo", v);
        s = tri2.testSerializable((byte)12, s, 13);
        this.logger.debug("returned: " + String.valueOf(s));
        if (s.getInt() != 1 || !s.getString().equals("woo") || s.getList().size() != 3 || s.getList().get(0) != 1 || s.getList().get(1) != 2 || s.getList().get(2) != 3) {
            TestAll.fail((String)"Didn't get back the same TestSerializable");
        }
    }

    @Test
    public void testComplex() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        Collator col = Collator.getInstance();
        col.setDecomposition(2);
        col.setStrength(0);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("cow", "moo");
        tri2.complexv((Variant<? extends Object>)new Variant(m, "a{ss}"));
        this.logger.debug("done");
        this.logger.debug("testing recursion...");
        if (0 != col.compare("This Is A UTF-8 Name: \ufeb1 !!", tri2.recursionTest())) {
            TestAll.fail((String)"recursion test failed");
        }
        this.logger.debug("done");
        this.logger.debug("testing method overloading...");
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface.class);
        if (1 != tri2.overload("foo")) {
            TestAll.fail((String)"wrong overloaded method called");
        }
        if (2 != tri2.overload((byte)0)) {
            TestAll.fail((String)"wrong overloaded method called");
        }
        if (3 != tri2.overload()) {
            TestAll.fail((String)"wrong overloaded method called");
        }
        if (4 != tri.overload()) {
            TestAll.fail((String)"wrong overloaded method called");
        }
    }

    @Test
    public void testOverload() throws DBusException {
        this.logger.debug("testing method overloading...");
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface.class);
        TestAll.assertEquals((int)1, (int)tri2.overload("foo"));
        TestAll.assertEquals((int)2, (int)tri2.overload((byte)0));
        TestAll.assertEquals((int)3, (int)tri2.overload());
        TestAll.assertEquals((int)4, (int)tri.overload());
    }

    @Test
    public void testRegression13291() throws DBusException {
        SampleRemoteInterface tri = (SampleRemoteInterface)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface.class);
        this.logger.debug("reg13291...");
        byte[] as = new byte[10];
        for (int i = 0; i < 10; ++i) {
            as[i] = (byte)(100 - i);
        }
        tri.reg13291(as, as);
        this.logger.debug("done");
    }

    @Test
    public void testNestedLists() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList<List<Integer>> lli = new ArrayList<List<Integer>>();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(1);
        lli.add(li);
        List<List<Integer>> reti = tri2.checklist(lli);
        if (reti.size() != 1 || reti.get(0).size() != 1 || reti.get(0).get(0) != 1) {
            TestAll.fail((String)"Failed to check nested lists");
        }
    }

    @Test
    public void testDynamicObjectCreation() throws DBusException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        SampleNewInterface tni = tri2.getNew();
        TestAll.assertEquals((Object)tni.getName(), (Object)SampleNewInterfaceClass.class.getSimpleName());
    }

    @Test
    public void testNestedListsAsync() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList lli = new ArrayList();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(57);
        lli.add(li);
        DBusAsyncReply checklistReply = this.clientconn.callMethodAsync((DBusInterface)tri2, "checklist", new Object[]{lli});
        Thread.sleep(500L);
        TestAll.assertIterableEquals(lli, (Iterable)((Iterable)checklistReply.getReply()), (String)"did not get back the same as sent in async");
        TestAll.assertIterableEquals(li, (Iterable)((Iterable)((List)checklistReply.getReply()).get(0)));
    }

    @Test
    public void testNestedListsCallback() throws DBusException, InterruptedException {
        SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)this.clientconn.getRemoteObject("foo.bar.Test", TEST_OBJECT_PATH, SampleRemoteInterface2.class);
        ArrayList lli = new ArrayList();
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(25);
        lli.add(li);
        NestedListCallbackHandler cbHandle = new NestedListCallbackHandler();
        this.clientconn.callWithCallback((DBusInterface)tri2, "checklist", (CallbackHandler)cbHandle, new Object[]{lli});
        Thread.sleep(500L);
        TestAll.assertIterableEquals(lli, cbHandle.getRetval(), (String)"did not get back the same as sent in async");
        TestAll.assertIterableEquals(li, (Iterable)cbHandle.getRetval().get(0));
    }

    private final class NestedListCallbackHandler
    implements CallbackHandler<List<List<Integer>>> {
        private List<List<Integer>> retval;

        private NestedListCallbackHandler() {
        }

        public void handle(List<List<Integer>> _r) {
            this.retval = _r;
        }

        public void handleError(DBusExecutionException _e) {
        }

        List<List<Integer>> getRetval() {
            return this.retval;
        }

        @Test
        public void testStructAsync() throws DBusException, InterruptedException {
            SampleRemoteInterface2 tri2 = (SampleRemoteInterface2)TestAll.this.clientconn.getRemoteObject("foo.bar.Test", TestAll.TEST_OBJECT_PATH, SampleRemoteInterface2.class);
            SampleStruct struct = new SampleStruct("fizbuzz", new UInt32(5248L), new Variant((Object)2234));
            DBusAsyncReply structReply = TestAll.this.clientconn.callMethodAsync((DBusInterface)tri2, "returnSamplestruct", new Object[]{struct});
            Thread.sleep(500L);
            Assertions.assertEquals((Object)((Object)struct), (Object)structReply.getReply(), (String)"struct did not match");
        }
    }
}

