/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.helper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.test.helper.SampleException;
import org.freedesktop.dbus.test.helper.SampleNewInterfaceClass;
import org.freedesktop.dbus.test.helper.SampleSerializable;
import org.freedesktop.dbus.test.helper.interfaces.SampleNewInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterface2;
import org.freedesktop.dbus.test.helper.interfaces.SampleRemoteInterfaceEnum;
import org.freedesktop.dbus.test.helper.structs.IntStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct;
import org.freedesktop.dbus.test.helper.structs.SampleStruct3;
import org.freedesktop.dbus.test.helper.structs.SampleStruct4;
import org.freedesktop.dbus.test.helper.structs.SampleTuple;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleClass
implements SampleRemoteInterface,
SampleRemoteInterface2,
SampleRemoteInterfaceEnum,
Properties {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DBusConnection conn;

    public SampleClass(DBusConnection _conn) {
        this.conn = _conn;
    }

    @Override
    public String Introspect() {
        return "Not XML";
    }

    @Override
    public int[][] teststructstruct(SampleStruct3 _in) {
        List<List<Integer>> lli = _in.getInnerListOfLists();
        int[][] out = new int[lli.size()][];
        for (int j = 0; j < out.length; ++j) {
            out[j] = new int[lli.get(j).size()];
            for (int k = 0; k < out[j].length; ++k) {
                out[j][k] = lli.get(j).get(k);
            }
        }
        return out;
    }

    @Override
    public int[][] testListstruct(SampleStruct4 _in) {
        List<IntStruct> list = _in.getInnerListOfLists();
        int size = list.size();
        int[][] retVal = new int[size][];
        for (int i = 0; i < size; ++i) {
            IntStruct elem = list.get(i);
            retVal[i] = new int[]{elem.getValue1(), elem.getValue2()};
        }
        return retVal;
    }

    @Override
    public float testfloat(float[] _f) {
        if (_f.length < 4 || _f[0] != 17.093f || _f[1] != -23.0f || _f[2] != 0.0f || _f[3] != 31.42f) {
            Assertions.fail((String)"testfloat got incorrect array");
        }
        return _f[0];
    }

    @Override
    public void newpathtest(DBusPath _p) {
        if (!_p.toString().equals("/new/path/test")) {
            Assertions.fail((String)"new path test got wrong path");
        }
    }

    @Override
    public void waitawhile() {
        this.logger.debug("Sleeping.");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logger.debug("Done sleeping.");
    }

    @Override
    public <A> SampleTuple<String, List<Integer>, Boolean> show(A _in) {
        this.logger.debug("Showing Stuff: " + String.valueOf(_in.getClass()) + "(" + String.valueOf(_in) + ")");
        if (!(_in instanceof Integer) || (Integer)_in != 234) {
            Assertions.fail((String)"show received the wrong arguments");
        }
        DBusCallInfo info = AbstractConnection.getCallInfo();
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1953);
        return new SampleTuple<String, List<Integer>, Boolean>(info.getSource(), l, true);
    }

    @Override
    public <T> T dostuff(SampleStruct _foo) {
        this.logger.debug("Doing Stuff " + String.valueOf((Object)_foo));
        this.logger.debug(" -- (" + String.valueOf(_foo.getStringValue().getClass()) + ", " + String.valueOf(_foo.getInt32Value().getClass()) + ", " + String.valueOf(_foo.getVariantValue().getClass()) + ")");
        if (!(_foo instanceof SampleStruct && _foo.getStringValue() instanceof String && _foo.getInt32Value() instanceof UInt32 && _foo.getVariantValue() instanceof Variant && "bar".equals(_foo.getStringValue()) && _foo.getInt32Value().intValue() == 52 && _foo.getVariantValue().getValue() instanceof Boolean && ((Boolean)_foo.getVariantValue().getValue()).booleanValue())) {
            Assertions.fail((String)"dostuff received the wrong arguments");
        }
        return (T)_foo.getVariantValue().getValue();
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return null;
    }

    @Override
    public List<Integer> sampleArray(List<String> _ss, Integer[] _is, long[] _ls) {
        this.logger.debug("Got an array:");
        for (String s : _ss) {
            this.logger.debug("--" + s);
        }
        if (!(_ss.size() == 5 && "hi".equals(_ss.get(0)) && "hello".equals(_ss.get(1)) && "hej".equals(_ss.get(2)) && "hey".equals(_ss.get(3)) && "aloha".equals(_ss.get(4)))) {
            Assertions.fail((String)"sampleArray, String array contents incorrect");
        }
        this.logger.debug("Got an array:");
        for (Integer i : _is) {
            this.logger.debug("--" + i);
        }
        if (_is.length != 4 || _is[0] != 1 || _is[1] != 5 || _is[2] != 7 || _is[3] != 9) {
            Assertions.fail((String)"sampleArray, Integer array contents incorrect");
        }
        this.logger.debug("Got an array:");
        for (long l : _ls) {
            this.logger.debug("--" + l);
        }
        if (_ls.length != 4 || _ls[0] != 2L || _ls[1] != 6L || _ls[2] != 8L || _ls[3] != 12L) {
            Assertions.fail((String)"sampleArray, Integer array contents incorrect");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(-1);
        arrayList.add(-5);
        arrayList.add(-7);
        arrayList.add(-12);
        arrayList.add(-18);
        return arrayList;
    }

    @Override
    public String getName() {
        return "This Is A UTF-8 Name: \u0633 !!";
    }

    @Override
    public String getNameAndThrow() throws SampleException {
        throw new SampleException("test");
    }

    @Override
    public boolean check() {
        this.logger.debug("Being checked");
        return false;
    }

    @Override
    public <T> int frobnicate(List<Long> _n, Map<String, Map<UInt16, Short>> _m, T _v) {
        Map<UInt16, Short> mus;
        if (null == _n) {
            Assertions.fail((String)"List was null");
        }
        if (_n.size() != 3) {
            Assertions.fail((String)("List was wrong size (expected 3, actual " + _n.size() + ")"));
        }
        if (_n.get(0) != 2L || _n.get(1) != 5L || _n.get(2) != 71L) {
            Assertions.fail((String)"List has wrong contents");
        }
        if (!(_v instanceof Integer)) {
            Assertions.fail((String)"v not an Integer");
        }
        if ((Integer)_v != 13) {
            Assertions.fail((String)"v is incorrect");
        }
        if (null == _m) {
            Assertions.fail((String)"Map was null");
        }
        if (_m.size() != 1) {
            Assertions.fail((String)"Map was wrong size");
        }
        if (!_m.keySet().contains("stuff")) {
            Assertions.fail((String)"Incorrect key");
        }
        if (null == (mus = _m.get("stuff"))) {
            Assertions.fail((String)"Sub-Map was null");
        }
        if (mus.size() != 3) {
            Assertions.fail((String)"Sub-Map was wrong size");
        }
        if (!Short.valueOf((short)5).equals(mus.get(new UInt16(4)))) {
            Assertions.fail((String)"Sub-Map has wrong contents");
        }
        if (!Short.valueOf((short)6).equals(mus.get(new UInt16(5)))) {
            Assertions.fail((String)"Sub-Map has wrong contents");
        }
        if (!Short.valueOf((short)7).equals(mus.get(new UInt16(6)))) {
            Assertions.fail((String)"Sub-Map has wrong contents");
        }
        return -5;
    }

    @Override
    public DBusInterface getThis(DBusInterface _t) {
        if (!_t.equals((Object)this)) {
            Assertions.fail((String)"Didn't get this properly");
        }
        return this;
    }

    @Override
    public void throwme() throws SampleException {
        throw new SampleException("test");
    }

    @Override
    public SampleSerializable<String> testSerializable(byte _b, SampleSerializable<String> _s, int _i) {
        this.logger.debug("Recieving TestSerializable: " + String.valueOf(_s));
        if (_b != 12 || _i != 13 || _s.getInt() != 1 || !_s.getString().equals("woo") || _s.getList().size() != 3 || _s.getList().get(0) != 1 || _s.getList().get(1) != 2 || _s.getList().get(2) != 3) {
            Assertions.fail((String)"Error in recieving custom synchronisation");
        }
        return _s;
    }

    @Override
    public String recursionTest() {
        try {
            SampleRemoteInterface tri = (SampleRemoteInterface)this.conn.getRemoteObject("foo.bar.Test", "/TestAll", SampleRemoteInterface.class);
            return tri.getName();
        }
        catch (DBusException _ex) {
            Assertions.fail((String)("Failed with error: " + String.valueOf((Object)_ex)));
            return "";
        }
    }

    @Override
    public int overload(String _s) {
        return 1;
    }

    @Override
    public int overload(byte _b) {
        return 2;
    }

    @Override
    public int overload() {
        DBusCallInfo info = AbstractConnection.getCallInfo();
        if ("org.freedesktop.dbus.test.AlternateTestInterface".equals(info.getInterface())) {
            return 3;
        }
        if (SampleRemoteInterface.class.getName().equals(info.getInterface())) {
            return 4;
        }
        return -1;
    }

    @Override
    public List<List<Integer>> checklist(List<List<Integer>> _lli) {
        return _lli;
    }

    @Override
    public SampleNewInterface getNew() {
        SampleNewInterfaceClass n = new SampleNewInterfaceClass();
        try {
            this.conn.exportObject("/new", (DBusInterface)n);
        }
        catch (DBusException _ex) {
            throw new DBusExecutionException(_ex.getMessage());
        }
        return n;
    }

    @Override
    public void sig(Type[] _s) {
        if (!(_s.length == 2 && _s[0].equals(Byte.class) && _s[1] instanceof ParameterizedType && Map.class.equals((Object)((ParameterizedType)_s[1]).getRawType()) && ((ParameterizedType)_s[1]).getActualTypeArguments().length == 2 && CharSequence.class.equals((Object)((ParameterizedType)_s[1]).getActualTypeArguments()[0]) && Integer.class.equals((Object)((ParameterizedType)_s[1]).getActualTypeArguments()[1]))) {
            Assertions.fail((String)("Didn't send types correctly: " + Arrays.toString(_s)));
        }
    }

    @Override
    public void complexv(Variant<? extends Object> _v) {
        if (!("a{ss}".equals(_v.getSig()) && _v.getValue() instanceof Map && ((Map)_v.getValue()).size() == 1 && "moo".equals(((Map)_v.getValue()).get("cow")))) {
            Assertions.fail((String)"Didn't send variant correctly");
        }
    }

    @Override
    public void reg13291(byte[] _as, byte[] _bs) {
        if (_as.length != _bs.length) {
            Assertions.fail((String)"didn't receive identical byte arrays");
        }
        for (int i = 0; i < _as.length; ++i) {
            if (_as[i] == _bs[i]) continue;
            Assertions.fail((String)"didn't receive identical byte arrays");
        }
    }

    public <A> A Get(String _interfaceName, String _propertyName) {
        return (A)new DBusPath("/nonexistant/path");
    }

    public <A> void Set(String _interfaceName, String _propertyName, A _value) {
    }

    public Map<String, Variant<?>> GetAll(String _interfaceName) {
        return new HashMap();
    }

    @Override
    public DBusPath pathrv(DBusPath _a) {
        return _a;
    }

    @Override
    public List<DBusPath> pathlistrv(List<DBusPath> _list) {
        return _list;
    }

    @Override
    public Map<DBusPath, DBusPath> pathmaprv(Map<DBusPath, DBusPath> _map) {
        return _map;
    }

    @Override
    public SampleStruct returnSamplestruct(SampleStruct _s) {
        return _s;
    }

    @Override
    public SampleRemoteInterfaceEnum.TestEnum getEnumValue() {
        return SampleRemoteInterfaceEnum.TestEnum.TESTVAL2;
    }

    @Override
    public void thisShouldBeIgnored() {
        this.logger.error("You should never see this message!");
    }
}

